/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.net.http.HttpClient;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.net.ssl.SSLParameters;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.Empty;
import org.springframework.boot.http.client.HttpClientSettings;
import org.springframework.boot.http.client.HttpRedirects;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.util.Assert;

public final class JdkHttpClientBuilder {
    private final Consumer<HttpClient.Builder> customizer;

    public JdkHttpClientBuilder() {
        this(Empty.consumer());
    }

    private JdkHttpClientBuilder(Consumer<HttpClient.Builder> customizer) {
        this.customizer = customizer;
    }

    public JdkHttpClientBuilder withExecutor(Executor executor) {
        Assert.notNull((Object)executor, (String)"'executor' must not be null");
        return this.withCustomizer(httpClient -> httpClient.executor(executor));
    }

    public JdkHttpClientBuilder withCustomizer(Consumer<HttpClient.Builder> customizer) {
        Assert.notNull(customizer, (String)"'customizer' must not be null");
        return new JdkHttpClientBuilder(this.customizer.andThen(customizer));
    }

    public HttpClient build(@Nullable HttpClientSettings settings) {
        settings = settings != null ? settings : HttpClientSettings.DEFAULTS;
        Assert.isTrue((settings.readTimeout() == null ? 1 : 0) != 0, (String)"'settings' must not have a 'readTimeout'");
        HttpClient.Builder builder = HttpClient.newBuilder();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(settings::redirects).as(this::asHttpClientRedirect).to(builder::followRedirects);
        map.from(settings::connectTimeout).to(builder::connectTimeout);
        map.from(settings::sslBundle).as(SslBundle::createSslContext).to(builder::sslContext);
        map.from(settings::sslBundle).as(this::asSslParameters).to(builder::sslParameters);
        this.customizer.accept(builder);
        return builder.build();
    }

    private SSLParameters asSslParameters(SslBundle sslBundle) {
        SslOptions options = sslBundle.getOptions();
        SSLParameters parameters = new SSLParameters();
        parameters.setCipherSuites(options.getCiphers());
        parameters.setProtocols(options.getEnabledProtocols());
        return parameters;
    }

    private HttpClient.Redirect asHttpClientRedirect(HttpRedirects redirects) {
        return switch (redirects) {
            default -> throw new IncompatibleClassChangeError();
            case HttpRedirects.FOLLOW_WHEN_POSSIBLE, HttpRedirects.FOLLOW -> HttpClient.Redirect.NORMAL;
            case HttpRedirects.DONT_FOLLOW -> HttpClient.Redirect.NEVER;
        };
    }
}

