/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.autoconfigure.reactive;

import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.http.client.HttpRedirects;
import org.springframework.boot.http.client.autoconfigure.reactive.AbstractClientHttpConnectorProperties;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorBuilder;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorSettings;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.util.StringUtils;

public final class ClientHttpConnectors {
    private final ObjectFactory<SslBundles> sslBundles;
    private final AbstractClientHttpConnectorProperties[] orderedProperties;

    public ClientHttpConnectors(ObjectFactory<SslBundles> sslBundles, AbstractClientHttpConnectorProperties ... orderedProperties) {
        this.sslBundles = sslBundles;
        this.orderedProperties = orderedProperties;
    }

    public ClientHttpConnectorBuilder<?> builder(ClassLoader classLoader) {
        AbstractClientHttpConnectorProperties.Connector connector = this.getProperty(AbstractClientHttpConnectorProperties::getConnector);
        return connector != null ? connector.builder() : ClientHttpConnectorBuilder.detect(classLoader);
    }

    public ClientHttpConnectorSettings settings() {
        HttpRedirects redirects = this.getProperty(AbstractClientHttpConnectorProperties::getRedirects);
        Duration connectTimeout = this.getProperty(AbstractClientHttpConnectorProperties::getConnectTimeout);
        Duration readTimeout = this.getProperty(AbstractClientHttpConnectorProperties::getReadTimeout);
        String sslBundleName = this.getProperty(AbstractClientHttpConnectorProperties::getSsl, AbstractClientHttpConnectorProperties.Ssl::getBundle, StringUtils::hasText);
        SslBundle sslBundle = StringUtils.hasLength((String)sslBundleName) ? ((SslBundles)this.sslBundles.getObject()).getBundle(sslBundleName) : null;
        return new ClientHttpConnectorSettings(redirects, connectTimeout, readTimeout, sslBundle);
    }

    private <T> T getProperty(Function<AbstractClientHttpConnectorProperties, T> accessor) {
        return (T)this.getProperty(accessor, Function.identity(), Objects::nonNull);
    }

    private <P, T> T getProperty(Function<AbstractClientHttpConnectorProperties, P> accessor, Function<P, T> extractor, Predicate<T> predicate) {
        for (AbstractClientHttpConnectorProperties properties : this.orderedProperties) {
            T extracted;
            if (properties == null) continue;
            P value = accessor.apply(properties);
            T t = extracted = value != null ? (T)extractor.apply(value) : null;
            if (!predicate.test(extracted)) continue;
            return extracted;
        }
        return null;
    }
}

