/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.health.contributor;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.boot.health.contributor.HealthContributors;

class CompositeHealthContributors
implements HealthContributors {
    private final List<HealthContributors> contributors;

    CompositeHealthContributors(HealthContributors ... contributors) {
        this.contributors = List.of(contributors);
    }

    @Override
    public HealthContributor getContributor(String name) {
        return this.contributors.stream().map(contributors -> contributors.getContributor(name)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public Stream<HealthContributors.Entry> stream() {
        HashSet seen = new HashSet();
        return this.contributors.stream().flatMap(HealthContributors::stream).filter(element -> seen.add(element.name()));
    }
}

