/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.hazelcast.autoconfigure;

import com.hazelcast.client.config.ClientConfigRecognizer;
import com.hazelcast.config.ConfigStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.hazelcast.autoconfigure.HazelcastConfigResourceCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotatedTypeMetadata;

class HazelcastClientConfigAvailableCondition
extends HazelcastConfigResourceCondition {
    HazelcastClientConfigAvailableCondition() {
        super("hazelcast.client.config", "file:./hazelcast-client.xml", "classpath:/hazelcast-client.xml", "file:./hazelcast-client.yaml", "classpath:/hazelcast-client.yaml", "file:./hazelcast-client.yml", "classpath:/hazelcast-client.yml");
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        if (context.getEnvironment().containsProperty("spring.hazelcast.config")) {
            ConditionOutcome configValidationOutcome = HazelcastClientValidation.clientConfigOutcome(context, "spring.hazelcast.config", this.startConditionMessage());
            return configValidationOutcome != null ? configValidationOutcome : ConditionOutcome.match((ConditionMessage)this.startConditionMessage().foundExactly((Object)"property spring.hazelcast.config"));
        }
        return this.getResourceOutcome(context, metadata);
    }

    static class HazelcastClientValidation {
        HazelcastClientValidation() {
        }

        static ConditionOutcome clientConfigOutcome(ConditionContext context, String propertyName, ConditionMessage.Builder builder) {
            ConditionOutcome conditionOutcome;
            block9: {
                String resourcePath = context.getEnvironment().getProperty(propertyName);
                Resource resource = context.getResourceLoader().getResource(resourcePath);
                if (!resource.exists()) {
                    return ConditionOutcome.noMatch((ConditionMessage)builder.because("Hazelcast configuration does not exist"));
                }
                InputStream in = resource.getInputStream();
                try {
                    boolean clientConfig = new ClientConfigRecognizer().isRecognized(new ConfigStream(in));
                    conditionOutcome = new ConditionOutcome(clientConfig, HazelcastClientValidation.existingConfigurationOutcome(resource, clientConfig));
                    if (in == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable ex) {
                        return null;
                    }
                }
                in.close();
            }
            return conditionOutcome;
        }

        private static String existingConfigurationOutcome(Resource resource, boolean client) throws IOException {
            URL location = resource.getURL();
            return client ? "Hazelcast client configuration detected at '" + String.valueOf(location) + "'" : "Hazelcast server configuration detected  at '" + String.valueOf(location) + "'";
        }
    }
}

