/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.util;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.jspecify.annotations.Nullable;

public final class VersionExtractor {
    private VersionExtractor() {
    }

    public static @Nullable String forClass(Class<?> cls) {
        String string;
        String implementationVersion = cls.getPackage().getImplementationVersion();
        if (implementationVersion != null) {
            return implementationVersion;
        }
        URL codeSourceLocation = cls.getProtectionDomain().getCodeSource().getLocation();
        URLConnection connection = codeSourceLocation.openConnection();
        if (connection instanceof JarURLConnection) {
            JarURLConnection jarURLConnection = (JarURLConnection)connection;
            return VersionExtractor.getImplementationVersion(jarURLConnection.getJarFile());
        }
        JarFile jarFile = new JarFile(new File(codeSourceLocation.toURI()));
        try {
            string = VersionExtractor.getImplementationVersion(jarFile);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                return null;
            }
        }
        jarFile.close();
        return string;
    }

    private static String getImplementationVersion(JarFile jarFile) throws IOException {
        return jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }
}

