/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.work.DisableCachingByDefault;
import org.springframework.boot.buildpack.platform.build.BuildRequest;
import org.springframework.boot.buildpack.platform.build.Builder;
import org.springframework.boot.buildpack.platform.build.BuildpackReference;
import org.springframework.boot.buildpack.platform.build.Cache;
import org.springframework.boot.buildpack.platform.build.Creator;
import org.springframework.boot.buildpack.platform.build.PullPolicy;
import org.springframework.boot.buildpack.platform.docker.transport.DockerEngineException;
import org.springframework.boot.buildpack.platform.docker.type.Binding;
import org.springframework.boot.buildpack.platform.docker.type.ImageName;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.io.ZipFileTarArchive;
import org.springframework.boot.gradle.tasks.bundling.CacheSpec;
import org.springframework.boot.gradle.tasks.bundling.DockerSpec;
import org.springframework.boot.gradle.util.VersionExtractor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@DisableCachingByDefault
public abstract class BootBuildImage
extends DefaultTask {
    private final Property<PullPolicy> pullPolicy;
    private final String projectName = this.getProject().getName();
    private final CacheSpec buildWorkspace;
    private final CacheSpec buildCache;
    private final CacheSpec launchCache;
    private final DockerSpec docker;

    public BootBuildImage() {
        Project project = this.getProject();
        Property projectVersion = project.getObjects().property(String.class).convention(project.provider(() -> project.getVersion().toString()));
        this.getImageName().convention(project.provider(() -> {
            ImageName imageName = ImageName.of((String)this.projectName);
            if ("unspecified".equals(projectVersion.get())) {
                return ImageReference.of((ImageName)imageName).toString();
            }
            return ImageReference.of((ImageName)imageName, (String)((String)projectVersion.get())).toString();
        }));
        this.getTrustBuilder().convention((Object)null);
        this.getCleanCache().convention((Object)false);
        this.getVerboseLogging().convention((Object)false);
        this.getPublish().convention((Object)false);
        this.buildWorkspace = (CacheSpec)this.getProject().getObjects().newInstance(CacheSpec.class, new Object[0]);
        this.buildCache = (CacheSpec)this.getProject().getObjects().newInstance(CacheSpec.class, new Object[0]);
        this.launchCache = (CacheSpec)this.getProject().getObjects().newInstance(CacheSpec.class, new Object[0]);
        this.docker = (DockerSpec)this.getProject().getObjects().newInstance(DockerSpec.class, new Object[0]);
        this.pullPolicy = this.getProject().getObjects().property(PullPolicy.class);
        this.getSecurityOptions().convention((Iterable)null);
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract RegularFileProperty getArchiveFile();

    @Input
    @Optional
    @Option(option="imageName", description="The name of the image to generate")
    public abstract Property<String> getImageName();

    @Input
    @Optional
    @Option(option="builder", description="The name of the builder image to use")
    public abstract Property<String> getBuilder();

    @Input
    @Optional
    @Option(option="trustBuilder", description="Consider the builder trusted")
    public abstract Property<Boolean> getTrustBuilder();

    @Input
    @Optional
    @Option(option="runImage", description="The name of the run image to use")
    public abstract Property<String> getRunImage();

    @Input
    public abstract MapProperty<String, String> getEnvironment();

    @Input
    @Option(option="cleanCache", description="Clean caches before packaging")
    public abstract Property<Boolean> getCleanCache();

    @Input
    public abstract Property<Boolean> getVerboseLogging();

    @Input
    @Optional
    @Option(option="pullPolicy", description="The image pull policy")
    public Property<PullPolicy> getPullPolicy() {
        return this.pullPolicy;
    }

    public void setPullPolicy(String pullPolicy) {
        this.getPullPolicy().set((Object)PullPolicy.valueOf((String)pullPolicy));
    }

    @Input
    @Option(option="publishImage", description="Publish the built image to a registry")
    public abstract Property<Boolean> getPublish();

    @Input
    @Optional
    public abstract ListProperty<String> getBuildpacks();

    @Input
    @Optional
    public abstract ListProperty<String> getBindings();

    @Input
    @Optional
    public abstract ListProperty<String> getTags();

    @Input
    @Optional
    @Option(option="network", description="Connect detect and build containers to network")
    public abstract Property<String> getNetwork();

    @Nested
    @Optional
    public CacheSpec getBuildWorkspace() {
        return this.buildWorkspace;
    }

    public void buildWorkspace(Action<CacheSpec> action) {
        action.execute((Object)this.buildWorkspace);
    }

    @Nested
    @Optional
    public CacheSpec getBuildCache() {
        return this.buildCache;
    }

    public void buildCache(Action<CacheSpec> action) {
        action.execute((Object)this.buildCache);
    }

    @Nested
    @Optional
    public CacheSpec getLaunchCache() {
        return this.launchCache;
    }

    public void launchCache(Action<CacheSpec> action) {
        action.execute((Object)this.launchCache);
    }

    @Input
    @Optional
    @Option(option="createdDate", description="The date to use as the created date of the image")
    public abstract Property<String> getCreatedDate();

    @Input
    @Optional
    @Option(option="applicationDirectory", description="The directory containing application content in the image")
    public abstract Property<String> getApplicationDirectory();

    @Input
    @Optional
    @Option(option="securityOptions", description="Security options that will be applied to the builder container")
    public abstract ListProperty<String> getSecurityOptions();

    @Input
    @Optional
    @Option(option="imagePlatform", description="The platform (os/architecture/variant) that will be used for all pulled images")
    public abstract Property<String> getImagePlatform();

    @Nested
    public DockerSpec getDocker() {
        return this.docker;
    }

    public void docker(Action<DockerSpec> action) {
        action.execute((Object)this.docker);
    }

    @TaskAction
    void buildImage() throws DockerEngineException, IOException {
        Builder builder = new Builder(this.docker.asDockerConfiguration());
        BuildRequest request = this.createRequest();
        builder.build(request);
    }

    BuildRequest createRequest() {
        return this.customize(BuildRequest.of((ImageReference)((ImageReference)this.getImageName().map(ImageReference::of).get()), owner -> new ZipFileTarArchive(((RegularFile)this.getArchiveFile().get()).getAsFile(), owner)));
    }

    private BuildRequest customize(BuildRequest request) {
        request = this.customizeBuilder(request);
        if (this.getTrustBuilder().isPresent()) {
            request = request.withTrustBuilder(((Boolean)this.getTrustBuilder().get()).booleanValue());
        }
        request = this.customizeRunImage(request);
        request = this.customizeEnvironment(request);
        request = this.customizeCreator(request);
        request = request.withCleanCache(((Boolean)this.getCleanCache().get()).booleanValue());
        request = request.withVerboseLogging(((Boolean)this.getVerboseLogging().get()).booleanValue());
        request = this.customizePullPolicy(request);
        request = request.withPublish(((Boolean)this.getPublish().get()).booleanValue());
        request = this.customizeBuildpacks(request);
        request = this.customizeBindings(request);
        request = this.customizeTags(request);
        request = this.customizeCaches(request);
        request = request.withNetwork((String)this.getNetwork().getOrNull());
        request = this.customizeCreatedDate(request);
        request = this.customizeApplicationDirectory(request);
        request = this.customizeSecurityOptions(request);
        if (this.getImagePlatform().isPresent()) {
            request = request.withImagePlatform((String)this.getImagePlatform().get());
        }
        return request;
    }

    private BuildRequest customizeBuilder(BuildRequest request) {
        String builder = (String)this.getBuilder().getOrNull();
        if (StringUtils.hasText((String)builder)) {
            return request.withBuilder(ImageReference.of((String)builder));
        }
        return request;
    }

    private BuildRequest customizeRunImage(BuildRequest request) {
        String runImage = (String)this.getRunImage().getOrNull();
        if (StringUtils.hasText((String)runImage)) {
            return request.withRunImage(ImageReference.of((String)runImage));
        }
        return request;
    }

    private BuildRequest customizeEnvironment(BuildRequest request) {
        Map environment = (Map)this.getEnvironment().getOrNull();
        if (!CollectionUtils.isEmpty((Map)environment)) {
            request = request.withEnv(environment);
        }
        return request;
    }

    private BuildRequest customizeCreator(BuildRequest request) {
        String springBootVersion = VersionExtractor.forClass(BootBuildImage.class);
        if (StringUtils.hasText((String)springBootVersion)) {
            return request.withCreator(Creator.withVersion((String)springBootVersion));
        }
        return request;
    }

    private BuildRequest customizePullPolicy(BuildRequest request) {
        PullPolicy pullPolicy = (PullPolicy)this.getPullPolicy().getOrNull();
        if (pullPolicy != null) {
            request = request.withPullPolicy(pullPolicy);
        }
        return request;
    }

    private BuildRequest customizeBuildpacks(BuildRequest request) {
        List buildpacks = (List)this.getBuildpacks().getOrNull();
        if (!CollectionUtils.isEmpty((Collection)buildpacks)) {
            return request.withBuildpacks(buildpacks.stream().map(BuildpackReference::of).toList());
        }
        return request;
    }

    private BuildRequest customizeBindings(BuildRequest request) {
        List bindings = (List)this.getBindings().getOrNull();
        if (!CollectionUtils.isEmpty((Collection)bindings)) {
            return request.withBindings(bindings.stream().map(Binding::of).toList());
        }
        return request;
    }

    private BuildRequest customizeTags(BuildRequest request) {
        List tags = (List)this.getTags().getOrNull();
        if (!CollectionUtils.isEmpty((Collection)tags)) {
            return request.withTags(tags.stream().map(ImageReference::of).toList());
        }
        return request;
    }

    private BuildRequest customizeCaches(BuildRequest request) {
        Cache launchCache;
        Cache buildCache;
        Cache buildWorkspaceCache = this.buildWorkspace.asCache();
        if (buildWorkspaceCache != null) {
            request = request.withBuildWorkspace(buildWorkspaceCache);
        }
        if ((buildCache = this.buildCache.asCache()) != null) {
            request = request.withBuildCache(buildCache);
        }
        if ((launchCache = this.launchCache.asCache()) != null) {
            request = request.withLaunchCache(launchCache);
        }
        return request;
    }

    private BuildRequest customizeCreatedDate(BuildRequest request) {
        String createdDate = (String)this.getCreatedDate().getOrNull();
        if (createdDate != null) {
            return request.withCreatedDate(createdDate);
        }
        return request;
    }

    private BuildRequest customizeApplicationDirectory(BuildRequest request) {
        String applicationDirectory = (String)this.getApplicationDirectory().getOrNull();
        if (applicationDirectory != null) {
            return request.withApplicationDirectory(applicationDirectory);
        }
        return request;
    }

    private BuildRequest customizeSecurityOptions(BuildRequest request) {
        List securityOptions;
        if (this.getSecurityOptions().isPresent() && (securityOptions = (List)this.getSecurityOptions().getOrNull()) != null) {
            return request.withSecurityOptions(securityOptions);
        }
        return request;
    }
}

