/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.dsl;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.springframework.boot.gradle.tasks.buildinfo.BuildInfo;

public class SpringBootExtension {
    private final Project project;
    private final Property<String> mainClass;

    public SpringBootExtension(Project project) {
        this.project = project;
        this.mainClass = this.project.getObjects().property(String.class);
    }

    public Property<String> getMainClass() {
        return this.mainClass;
    }

    public void buildInfo() {
        this.buildInfo(null);
    }

    public void buildInfo(Action<BuildInfo> configurer) {
        TaskContainer tasks = this.project.getTasks();
        TaskProvider bootBuildInfo = tasks.register("bootBuildInfo", BuildInfo.class, this::configureBuildInfoTask);
        this.project.getPlugins().withType(JavaPlugin.class, plugin -> {
            tasks.named("classes").configure(task -> task.dependsOn(new Object[]{bootBuildInfo}));
            bootBuildInfo.configure(buildInfo -> buildInfo.getProperties().getArtifact().convention(this.project.provider(this::determineArtifactBaseName)));
        });
        if (configurer != null) {
            bootBuildInfo.configure(configurer);
        }
    }

    private void configureBuildInfoTask(BuildInfo task) {
        task.setGroup("build");
        task.setDescription("Generates a META-INF/build-info.properties file.");
        task.getDestinationDir().convention(this.project.getLayout().dir(this.project.provider(() -> new File(this.determineMainSourceSetResourcesOutputDir(), "META-INF"))));
    }

    private File determineMainSourceSetResourcesOutputDir() {
        return ((SourceSet)((JavaPluginExtension)this.project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().getByName("main")).getOutput().getResourcesDir();
    }

    private String determineArtifactBaseName() {
        Jar artifactTask = this.findArtifactTask();
        return artifactTask != null ? (String)artifactTask.getArchiveBaseName().get() : null;
    }

    private Jar findArtifactTask() {
        Jar artifactTask = (Jar)this.project.getTasks().findByName("bootWar");
        if (artifactTask != null) {
            return artifactTask;
        }
        return (Jar)this.project.getTasks().findByName("bootJar");
    }
}

