/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.springframework.boot.loader.tools.Layer;
import org.springframework.boot.loader.tools.Layers;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.layer.ApplicationContentFilter;
import org.springframework.boot.loader.tools.layer.ContentFilter;
import org.springframework.boot.loader.tools.layer.ContentSelector;
import org.springframework.boot.loader.tools.layer.CustomLayers;
import org.springframework.boot.loader.tools.layer.IncludeExcludeContentSelector;
import org.springframework.boot.loader.tools.layer.LibraryContentFilter;
import org.springframework.util.Assert;

public abstract class LayeredSpec {
    private ApplicationSpec application;
    private DependenciesSpec dependencies;
    private Layers layers;

    @Inject
    public LayeredSpec(ObjectFactory objects) {
        this.application = (ApplicationSpec)objects.newInstance(ApplicationSpec.class, new Object[0]);
        this.dependencies = (DependenciesSpec)objects.newInstance(DependenciesSpec.class, new Object[0]);
        this.getEnabled().convention((Object)true);
        this.getIncludeLayerTools().convention((Object)true);
    }

    @Input
    public abstract Property<Boolean> getIncludeLayerTools();

    @Input
    public abstract Property<Boolean> getEnabled();

    @Input
    public ApplicationSpec getApplication() {
        return this.application;
    }

    public void setApplication(ApplicationSpec spec) {
        this.application = spec;
    }

    public void application(Action<ApplicationSpec> action) {
        action.execute((Object)this.application);
    }

    @Input
    public DependenciesSpec getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(DependenciesSpec spec) {
        this.dependencies = spec;
    }

    public void dependencies(Action<DependenciesSpec> action) {
        action.execute((Object)this.dependencies);
    }

    @Input
    @Optional
    public abstract ListProperty<String> getLayerOrder();

    Layers asLayers() {
        Layers layers = this.layers;
        if (layers == null) {
            this.layers = layers = this.createLayers();
        }
        return layers;
    }

    private Layers createLayers() {
        List layerOrder = (List)this.getLayerOrder().getOrNull();
        if (layerOrder == null || layerOrder.isEmpty()) {
            Assert.state((this.application.isEmpty() && this.dependencies.isEmpty() ? 1 : 0) != 0, (String)"The 'layerOrder' must be defined when using custom layering");
            return Layers.IMPLICIT;
        }
        List<Layer> layers = layerOrder.stream().map(Layer::new).toList();
        return new CustomLayers(layers, this.application.asSelectors(), this.dependencies.asSelectors());
    }

    public static class ApplicationSpec
    extends IntoLayersSpec<IntoLayerSpec> {
        @Inject
        public ApplicationSpec() {
            super(new IntoLayerSpecFactory(), new IntoLayerSpec[0]);
        }

        public ApplicationSpec(IntoLayerSpec ... contents) {
            super(new IntoLayerSpecFactory(), contents);
        }

        List<ContentSelector<String>> asSelectors() {
            return this.asSelectors(spec -> spec.asSelector(ApplicationContentFilter::new));
        }

        private static final class IntoLayerSpecFactory
        implements Function<String, IntoLayerSpec>,
        Serializable {
            private IntoLayerSpecFactory() {
            }

            @Override
            public IntoLayerSpec apply(String layer) {
                return new IntoLayerSpec(layer);
            }
        }
    }

    public static class DependenciesSpec
    extends IntoLayersSpec<DependenciesIntoLayerSpec>
    implements Serializable {
        @Inject
        public DependenciesSpec() {
            super(new IntoLayerSpecFactory(), new IntoLayerSpec[0]);
        }

        public DependenciesSpec(DependenciesIntoLayerSpec ... contents) {
            super(new IntoLayerSpecFactory(), contents);
        }

        List<ContentSelector<Library>> asSelectors() {
            return this.asSelectors(spec -> ((DependenciesIntoLayerSpec)spec).asLibrarySelector(LibraryContentFilter::new));
        }

        private static final class IntoLayerSpecFactory
        implements Function<String, DependenciesIntoLayerSpec>,
        Serializable {
            private IntoLayerSpecFactory() {
            }

            @Override
            public DependenciesIntoLayerSpec apply(String layer) {
                return new DependenciesIntoLayerSpec(layer);
            }
        }
    }

    public static class DependenciesIntoLayerSpec
    extends IntoLayerSpec {
        private boolean includeProjectDependencies;
        private boolean excludeProjectDependencies;

        public DependenciesIntoLayerSpec(String intoLayer) {
            super(intoLayer);
        }

        public void includeProjectDependencies() {
            this.includeProjectDependencies = true;
        }

        public void excludeProjectDependencies() {
            this.excludeProjectDependencies = true;
        }

        ContentSelector<Library> asLibrarySelector(Function<String, ContentFilter<Library>> filterFactory) {
            Layer layer = new Layer(this.getIntoLayer());
            List includeFilters = this.getIncludes().stream().map(filterFactory).collect(Collectors.toCollection(ArrayList::new));
            if (this.includeProjectDependencies) {
                includeFilters.add(Library::isLocal);
            }
            List excludeFilters = this.getExcludes().stream().map(filterFactory).collect(Collectors.toCollection(ArrayList::new));
            if (this.excludeProjectDependencies) {
                excludeFilters.add(Library::isLocal);
            }
            return new IncludeExcludeContentSelector(layer, includeFilters, excludeFilters);
        }
    }

    public static class IntoLayerSpec
    implements Serializable {
        private final String intoLayer;
        private final List<String> includes = new ArrayList<String>();
        private final List<String> excludes = new ArrayList<String>();

        public IntoLayerSpec(String intoLayer) {
            this.intoLayer = intoLayer;
        }

        public void include(String ... patterns) {
            this.includes.addAll(Arrays.asList(patterns));
        }

        public void exclude(String ... patterns) {
            this.includes.addAll(Arrays.asList(patterns));
        }

        <T> ContentSelector<T> asSelector(Function<String, ContentFilter<T>> filterFactory) {
            Layer layer = new Layer(this.intoLayer);
            return new IncludeExcludeContentSelector(layer, this.includes, this.excludes, filterFactory);
        }

        String getIntoLayer() {
            return this.intoLayer;
        }

        List<String> getIncludes() {
            return this.includes;
        }

        List<String> getExcludes() {
            return this.excludes;
        }
    }

    public static abstract class IntoLayersSpec<S extends IntoLayerSpec>
    implements Serializable {
        private final List<IntoLayerSpec> intoLayers;
        private final Function<String, S> specFactory;

        boolean isEmpty() {
            return this.intoLayers.isEmpty();
        }

        IntoLayersSpec(Function<String, S> specFactory, IntoLayerSpec ... spec) {
            this.intoLayers = new ArrayList<IntoLayerSpec>(Arrays.asList(spec));
            this.specFactory = specFactory;
        }

        public void intoLayer(String layer) {
            this.intoLayers.add((IntoLayerSpec)this.specFactory.apply(layer));
        }

        public void intoLayer(String layer, Action<S> action) {
            IntoLayerSpec spec = (IntoLayerSpec)this.specFactory.apply(layer);
            action.execute((Object)spec);
            this.intoLayers.add(spec);
        }

        <T> List<ContentSelector<T>> asSelectors(Function<IntoLayerSpec, ContentSelector<T>> selectorFactory) {
            return this.intoLayers.stream().map(selectorFactory).toList();
        }
    }
}

