/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.buildinfo;

import java.io.Serializable;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.springframework.util.function.SingletonSupplier;

public abstract class BuildInfoProperties
implements Serializable {
    private final SetProperty<String> excludes;
    private final Supplier<String> creationTime = SingletonSupplier.of((Supplier)new CurrentIsoInstantSupplier());

    @Inject
    public BuildInfoProperties(Project project, SetProperty<String> excludes) {
        this.excludes = excludes;
        this.getGroup().convention(project.provider(() -> project.getGroup().toString()));
        this.getVersion().convention(project.provider(() -> project.getVersion().toString()));
        this.getArtifact().convention(project.provider(() -> project.findProperty("archivesBaseName")).map(Object::toString));
        this.getName().convention(project.provider(() -> ((Project)project).getName()));
    }

    @Internal
    public abstract Property<String> getGroup();

    @Internal
    public abstract Property<String> getArtifact();

    @Internal
    public abstract Property<String> getVersion();

    @Internal
    public abstract Property<String> getName();

    @Internal
    public abstract Property<String> getTime();

    @Internal
    public abstract MapProperty<String, Object> getAdditional();

    @Input
    @Optional
    String getArtifactIfNotExcluded() {
        return this.getIfNotExcluded(this.getArtifact(), "artifact");
    }

    @Input
    @Optional
    String getGroupIfNotExcluded() {
        return this.getIfNotExcluded(this.getGroup(), "group");
    }

    @Input
    @Optional
    String getNameIfNotExcluded() {
        return this.getIfNotExcluded(this.getName(), "name");
    }

    @Input
    @Optional
    Instant getTimeIfNotExcluded() {
        String time = this.getIfNotExcluded(this.getTime(), "time", this.creationTime);
        return time != null ? Instant.parse(time) : null;
    }

    @Input
    @Optional
    String getVersionIfNotExcluded() {
        return this.getIfNotExcluded(this.getVersion(), "version");
    }

    @Input
    Map<String, String> getAdditionalIfNotExcluded() {
        return this.coerceToStringValues(this.applyExclusions((Map)this.getAdditional().getOrElse(Collections.emptyMap())));
    }

    private <T> T getIfNotExcluded(Property<T> property, String name) {
        return (T)this.getIfNotExcluded(property, name, () -> null);
    }

    private <T> T getIfNotExcluded(Property<T> property, String name, Supplier<T> defaultValue) {
        if (((Set)this.excludes.getOrElse(Collections.emptySet())).contains(name)) {
            return null;
        }
        return (T)property.getOrElse(defaultValue.get());
    }

    private Map<String, String> coerceToStringValues(Map<String, Object> input) {
        HashMap<String, String> output = new HashMap<String, String>();
        input.forEach((key, value) -> {
            if (value instanceof Provider) {
                Provider provider = (Provider)value;
                value = provider.getOrNull();
            }
            output.put((String)key, value != null ? value.toString() : null);
        });
        return output;
    }

    private Map<String, Object> applyExclusions(Map<String, Object> input) {
        HashMap<String, Object> output = new HashMap<String, Object>();
        Set exclusions = (Set)this.excludes.getOrElse(Collections.emptySet());
        input.forEach((key, value) -> output.put((String)key, !exclusions.contains(key) ? value : null));
        return output;
    }

    private static final class CurrentIsoInstantSupplier
    implements Supplier<String> {
        private CurrentIsoInstantSupplier() {
        }

        @Override
        public String get() {
            return DateTimeFormatter.ISO_INSTANT.format(Instant.now());
        }
    }
}

