/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.io.File;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.specs.Spec;
import org.springframework.boot.gradle.tasks.bundling.LayeredSpec;
import org.springframework.boot.gradle.tasks.bundling.ResolvedDependencies;
import org.springframework.boot.loader.tools.Layer;
import org.springframework.boot.loader.tools.Library;

class LayerResolver {
    private final ResolvedDependencies resolvedDependencies;
    private final LayeredSpec layeredConfiguration;
    private final Spec<FileCopyDetails> librarySpec;

    LayerResolver(ResolvedDependencies resolvedDependencies, LayeredSpec layeredConfiguration, Spec<FileCopyDetails> librarySpec) {
        this.resolvedDependencies = resolvedDependencies;
        this.layeredConfiguration = layeredConfiguration;
        this.librarySpec = librarySpec;
    }

    Layer getLayer(FileCopyDetails details) {
        try {
            if (this.librarySpec.isSatisfiedBy((Object)details)) {
                return this.getLayer(this.asLibrary(details));
            }
            return this.getLayer(details.getSourcePath());
        }
        catch (UnsupportedOperationException ex) {
            return null;
        }
    }

    Layer getLayer(Library library) {
        return this.layeredConfiguration.asLayers().getLayer(library);
    }

    Layer getLayer(String applicationResource) {
        return this.layeredConfiguration.asLayers().getLayer(applicationResource);
    }

    Iterable<Layer> getLayers() {
        return this.layeredConfiguration.asLayers();
    }

    private Library asLibrary(FileCopyDetails details) {
        File file = details.getFile();
        ResolvedDependencies.DependencyDescriptor dependency = this.resolvedDependencies.find(file);
        return dependency != null ? new Library(null, file, null, dependency.getCoordinates(), false, dependency.isProjectDependency()) : new Library(file, null);
    }
}

