/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.run;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.springframework.boot.gradle.run.SourceSets;
import org.springframework.boot.loader.tools.FileUtils;

public class BootRunTask
extends JavaExec {
    private boolean addResources = false;

    public boolean getAddResources() {
        return this.addResources;
    }

    public void setAddResources(boolean addResources) {
        this.addResources = addResources;
    }

    public void exec() {
        if (System.console() != null) {
            this.getEnvironment().put("spring.output.ansi.console-available", true);
        }
        this.addResourcesIfNecessary();
        super.exec();
    }

    private void addResourcesIfNecessary() {
        if (this.addResources) {
            SourceSet mainSourceSet = SourceSets.findMainSourceSet(this.getProject());
            File outputDir = mainSourceSet != null ? mainSourceSet.getOutput().getResourcesDir() : null;
            LinkedHashSet resources = new LinkedHashSet();
            if (mainSourceSet != null) {
                resources.addAll(mainSourceSet.getResources().getSrcDirs());
            }
            ArrayList classPath = new ArrayList(this.getClasspath().getFiles());
            classPath.addAll(0, resources);
            this.getLogger().info("Adding classpath: " + resources);
            this.setClasspath((FileCollection)new SimpleFileCollection(classPath));
            if (outputDir != null) {
                for (File directory : resources) {
                    FileUtils.removeDuplicatesFromOutputDirectory((File)outputDir, (File)directory);
                }
            }
        }
    }
}

