/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle;

import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.compile.JavaCompile;
import org.springframework.boot.gradle.SpringBootPluginExtension;
import org.springframework.boot.gradle.agent.AgentPluginFeatures;
import org.springframework.boot.gradle.dependencymanagement.DependencyManagementPluginFeatures;
import org.springframework.boot.gradle.repackage.RepackagePluginFeatures;
import org.springframework.boot.gradle.run.RunPluginFeatures;

public class SpringBootPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getExtensions().create("springBoot", SpringBootPluginExtension.class, new Object[0]);
        project.getPlugins().apply(JavaPlugin.class);
        new AgentPluginFeatures().apply(project);
        new RepackagePluginFeatures().apply(project);
        new RunPluginFeatures().apply(project);
        new DependencyManagementPluginFeatures().apply(project);
        project.getTasks().withType(JavaCompile.class).all((Action)new SetUtf8EncodingAction());
    }

    private static class SetUtf8EncodingAction
    implements Action<JavaCompile> {
        private SetUtf8EncodingAction() {
        }

        public void execute(final JavaCompile compile) {
            compile.doFirst((Action)new Action<Task>(){

                public void execute(Task t) {
                    if (compile.getOptions().getEncoding() == null) {
                        compile.getOptions().setEncoding("UTF-8");
                    }
                }
            });
        }
    }
}

