/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.freemarker.autoconfigure;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.freemarker.autoconfigure.AbstractFreeMarkerConfiguration;
import org.springframework.boot.freemarker.autoconfigure.FreeMarkerProperties;
import org.springframework.boot.freemarker.autoconfigure.FreeMarkerVariablesCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.ui.freemarker.FreeMarkerConfigurationFactory;
import org.springframework.web.reactive.result.view.freemarker.FreeMarkerConfig;
import org.springframework.web.reactive.result.view.freemarker.FreeMarkerConfigurer;
import org.springframework.web.reactive.result.view.freemarker.FreeMarkerViewResolver;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={FreeMarkerConfigurer.class})
@AutoConfigureAfter(name={"org.springframework.boot.webflux.autoconfigure.WebFluxAutoConfiguration"})
class FreeMarkerReactiveWebConfiguration
extends AbstractFreeMarkerConfiguration {
    FreeMarkerReactiveWebConfiguration(FreeMarkerProperties properties, ObjectProvider<FreeMarkerVariablesCustomizer> variablesCustomizers) {
        super(properties, variablesCustomizers);
    }

    @Bean
    @ConditionalOnMissingBean(value={FreeMarkerConfig.class})
    FreeMarkerConfigurer freeMarkerConfigurer() {
        FreeMarkerConfigurer configurer = new FreeMarkerConfigurer();
        this.applyProperties((FreeMarkerConfigurationFactory)configurer);
        return configurer;
    }

    @Bean
    freemarker.template.Configuration freeMarkerConfiguration(FreeMarkerConfig configurer) {
        return configurer.getConfiguration();
    }

    @Bean
    @ConditionalOnMissingBean(name={"freeMarkerViewResolver"})
    FreeMarkerViewResolver freeMarkerViewResolver() {
        FreeMarkerViewResolver resolver = new FreeMarkerViewResolver();
        resolver.setPrefix(this.getProperties().getPrefix());
        resolver.setSuffix(this.getProperties().getSuffix());
        resolver.setRequestContextAttribute(this.getProperties().getRequestContextAttribute());
        resolver.setViewNames(this.getProperties().getViewNames());
        return resolver;
    }
}

