/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.freemarker.autoconfigure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.autoconfigure.template.PathBasedTemplateAvailabilityProvider;
import org.springframework.boot.context.properties.bind.BindableRuntimeHintsRegistrar;
import org.springframework.util.ClassUtils;

public class FreeMarkerTemplateAvailabilityProvider
extends PathBasedTemplateAvailabilityProvider {
    private static final String REQUIRED_CLASS_NAME = "freemarker.template.Configuration";

    public FreeMarkerTemplateAvailabilityProvider() {
        super(REQUIRED_CLASS_NAME, FreeMarkerTemplateAvailabilityProperties.class, "spring.freemarker");
    }

    protected static final class FreeMarkerTemplateAvailabilityProperties
    extends PathBasedTemplateAvailabilityProvider.TemplateAvailabilityProperties {
        private List<String> templateLoaderPath = new ArrayList<String>(Arrays.asList("classpath:/templates/"));

        FreeMarkerTemplateAvailabilityProperties() {
            super("", ".ftlh");
        }

        protected List<String> getLoaderPath() {
            return this.templateLoaderPath;
        }

        public List<String> getTemplateLoaderPath() {
            return this.templateLoaderPath;
        }

        public void setTemplateLoaderPath(List<String> templateLoaderPath) {
            this.templateLoaderPath = templateLoaderPath;
        }
    }

    static class FreeMarkerTemplateAvailabilityRuntimeHints
    implements RuntimeHintsRegistrar {
        FreeMarkerTemplateAvailabilityRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            if (ClassUtils.isPresent((String)FreeMarkerTemplateAvailabilityProvider.REQUIRED_CLASS_NAME, (ClassLoader)classLoader)) {
                BindableRuntimeHintsRegistrar.forTypes((Class[])new Class[]{FreeMarkerTemplateAvailabilityProperties.class}).registerHints(hints, classLoader);
            }
        }
    }
}

