/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.freemarker.autoconfigure;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;

@ConfigurationProperties(value="spring.freemarker")
public class FreeMarkerProperties {
    public static final String DEFAULT_TEMPLATE_LOADER_PATH = "classpath:/templates/";
    public static final String DEFAULT_PREFIX = "";
    public static final String DEFAULT_SUFFIX = ".ftlh";
    private static final MimeType DEFAULT_CONTENT_TYPE = MimeType.valueOf((String)"text/html");
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private boolean enabled = true;
    private boolean cache;
    private MimeType contentType = DEFAULT_CONTENT_TYPE;
    private Charset charset = DEFAULT_CHARSET;
    private String[] viewNames;
    private boolean checkTemplateLocation = true;
    private String prefix = "";
    private String suffix = ".ftlh";
    private String requestContextAttribute;
    private boolean exposeRequestAttributes = false;
    private boolean exposeSessionAttributes = false;
    private boolean allowRequestOverride = false;
    private boolean exposeSpringMacroHelpers = true;
    private boolean allowSessionOverride = false;
    private Map<String, String> settings = new HashMap<String, String>();
    private String[] templateLoaderPath = new String[]{"classpath:/templates/"};
    private boolean preferFileSystemAccess;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setCheckTemplateLocation(boolean checkTemplateLocation) {
        this.checkTemplateLocation = checkTemplateLocation;
    }

    public boolean isCheckTemplateLocation() {
        return this.checkTemplateLocation;
    }

    public String[] getViewNames() {
        return this.viewNames;
    }

    public void setViewNames(String[] viewNames) {
        this.viewNames = viewNames;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public MimeType getContentType() {
        if (this.contentType.getCharset() == null) {
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            parameters.put("charset", this.charset.name());
            parameters.putAll(this.contentType.getParameters());
            return new MimeType(this.contentType, parameters);
        }
        return this.contentType;
    }

    public void setContentType(MimeType contentType) {
        this.contentType = contentType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getCharsetName() {
        return this.charset != null ? this.charset.name() : null;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, String> settings) {
        this.settings = settings;
    }

    public String[] getTemplateLoaderPath() {
        return this.templateLoaderPath;
    }

    public void setTemplateLoaderPath(String ... templateLoaderPaths) {
        this.templateLoaderPath = templateLoaderPaths;
    }

    public boolean isPreferFileSystemAccess() {
        return this.preferFileSystemAccess;
    }

    public void setPreferFileSystemAccess(boolean preferFileSystemAccess) {
        this.preferFileSystemAccess = preferFileSystemAccess;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getRequestContextAttribute() {
        return this.requestContextAttribute;
    }

    public void setRequestContextAttribute(String requestContextAttribute) {
        this.requestContextAttribute = requestContextAttribute;
    }

    public boolean isExposeRequestAttributes() {
        return this.exposeRequestAttributes;
    }

    public void setExposeRequestAttributes(boolean exposeRequestAttributes) {
        this.exposeRequestAttributes = exposeRequestAttributes;
    }

    public boolean isExposeSessionAttributes() {
        return this.exposeSessionAttributes;
    }

    public void setExposeSessionAttributes(boolean exposeSessionAttributes) {
        this.exposeSessionAttributes = exposeSessionAttributes;
    }

    public boolean isAllowRequestOverride() {
        return this.allowRequestOverride;
    }

    public void setAllowRequestOverride(boolean allowRequestOverride) {
        this.allowRequestOverride = allowRequestOverride;
    }

    public boolean isAllowSessionOverride() {
        return this.allowSessionOverride;
    }

    public void setAllowSessionOverride(boolean allowSessionOverride) {
        this.allowSessionOverride = allowSessionOverride;
    }

    public boolean isExposeSpringMacroHelpers() {
        return this.exposeSpringMacroHelpers;
    }

    public void setExposeSpringMacroHelpers(boolean exposeSpringMacroHelpers) {
        this.exposeSpringMacroHelpers = exposeSpringMacroHelpers;
    }

    public void applyToMvcViewResolver(Object viewResolver) {
        Assert.isInstanceOf(AbstractTemplateViewResolver.class, (Object)viewResolver, () -> "ViewResolver is not an instance of AbstractTemplateViewResolver :" + String.valueOf(viewResolver));
        AbstractTemplateViewResolver resolver = (AbstractTemplateViewResolver)viewResolver;
        resolver.setPrefix(this.getPrefix());
        resolver.setSuffix(this.getSuffix());
        resolver.setCache(this.isCache());
        if (this.getContentType() != null) {
            resolver.setContentType(this.getContentType().toString());
        }
        resolver.setViewNames(this.getViewNames());
        resolver.setExposeRequestAttributes(this.isExposeRequestAttributes());
        resolver.setAllowRequestOverride(this.isAllowRequestOverride());
        resolver.setAllowSessionOverride(this.isAllowSessionOverride());
        resolver.setExposeSessionAttributes(this.isExposeSessionAttributes());
        resolver.setExposeSpringMacroHelpers(this.isExposeSpringMacroHelpers());
        resolver.setRequestContextAttribute(this.getRequestContextAttribute());
        resolver.setOrder(0x7FFFFFFA);
    }
}

