/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.flyway.autoconfigure;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(value="spring.flyway")
public class FlywayProperties {
    private boolean enabled = true;
    private boolean failOnMissingLocations;
    private List<String> locations = new ArrayList<String>(Collections.singletonList("classpath:db/migration"));
    private List<String> callbackLocations = new ArrayList<String>();
    private Charset encoding = StandardCharsets.UTF_8;
    private int connectRetries;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration connectRetriesInterval = Duration.ofSeconds(120L);
    private int lockRetryCount = 50;
    private @Nullable String defaultSchema;
    private List<String> schemas = new ArrayList<String>();
    private boolean createSchemas = true;
    private String table = "flyway_schema_history";
    private @Nullable String tablespace;
    private String baselineDescription = "<< Flyway Baseline >>";
    private String baselineVersion = "1";
    private @Nullable String installedBy;
    private Map<String, String> placeholders = new HashMap<String, String>();
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private String placeholderSeparator = ":";
    private boolean placeholderReplacement = true;
    private String sqlMigrationPrefix = "V";
    private List<String> sqlMigrationSuffixes = new ArrayList<String>(Collections.singleton(".sql"));
    private String sqlMigrationSeparator = "__";
    private String repeatableSqlMigrationPrefix = "R";
    private String target = "latest";
    private @Nullable String user;
    private @Nullable String password;
    private @Nullable String driverClassName;
    private @Nullable String url;
    private List<String> initSqls = new ArrayList<String>();
    private boolean baselineOnMigrate;
    private boolean cleanDisabled = true;
    private boolean group;
    private boolean mixed;
    private boolean outOfOrder;
    private boolean skipDefaultCallbacks;
    private boolean skipDefaultResolvers;
    private boolean validateMigrationNaming = false;
    private boolean validateOnMigrate = true;
    private String scriptPlaceholderPrefix = "FP__";
    private String scriptPlaceholderSuffix = "__";
    private @Nullable String powershellExecutable;
    private boolean executeInTransaction = true;
    private String[] loggers = new String[]{"slf4j"};
    private @Nullable Boolean batch;
    private @Nullable File dryRunOutput;
    private String @Nullable [] errorOverrides;
    private @Nullable Boolean stream;
    private Map<String, String> jdbcProperties = new HashMap<String, String>();
    private @Nullable String kerberosConfigFile;
    private @Nullable Boolean outputQueryResults;
    private @Nullable Boolean skipExecutingMigrations;
    private List<String> ignoreMigrationPatterns = Collections.singletonList("*:future");
    private @Nullable Boolean detectEncoding;
    private @Nullable Boolean communityDbSupportEnabled;
    private final Oracle oracle = new Oracle();
    private final Postgresql postgresql = new Postgresql();
    private final Sqlserver sqlserver = new Sqlserver();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isFailOnMissingLocations() {
        return this.failOnMissingLocations;
    }

    public void setFailOnMissingLocations(boolean failOnMissingLocations) {
        this.failOnMissingLocations = failOnMissingLocations;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public List<String> getCallbackLocations() {
        return this.callbackLocations;
    }

    public void setCallbackLocations(List<String> callbackLocations) {
        this.callbackLocations = callbackLocations;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public int getConnectRetries() {
        return this.connectRetries;
    }

    public void setConnectRetries(int connectRetries) {
        this.connectRetries = connectRetries;
    }

    public Duration getConnectRetriesInterval() {
        return this.connectRetriesInterval;
    }

    public void setConnectRetriesInterval(Duration connectRetriesInterval) {
        this.connectRetriesInterval = connectRetriesInterval;
    }

    public int getLockRetryCount() {
        return this.lockRetryCount;
    }

    public void setLockRetryCount(Integer lockRetryCount) {
        this.lockRetryCount = lockRetryCount;
    }

    public @Nullable String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(@Nullable String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    public boolean isCreateSchemas() {
        return this.createSchemas;
    }

    public void setCreateSchemas(boolean createSchemas) {
        this.createSchemas = createSchemas;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public @Nullable String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(@Nullable String tablespace) {
        this.tablespace = tablespace;
    }

    public String getBaselineDescription() {
        return this.baselineDescription;
    }

    public void setBaselineDescription(String baselineDescription) {
        this.baselineDescription = baselineDescription;
    }

    public String getBaselineVersion() {
        return this.baselineVersion;
    }

    public void setBaselineVersion(String baselineVersion) {
        this.baselineVersion = baselineVersion;
    }

    public @Nullable String getInstalledBy() {
        return this.installedBy;
    }

    public void setInstalledBy(@Nullable String installedBy) {
        this.installedBy = installedBy;
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    public String getPlaceholderSeparator() {
        return this.placeholderSeparator;
    }

    public void setPlaceholderSeparator(String placeholderSeparator) {
        this.placeholderSeparator = placeholderSeparator;
    }

    public boolean isPlaceholderReplacement() {
        return this.placeholderReplacement;
    }

    public void setPlaceholderReplacement(boolean placeholderReplacement) {
        this.placeholderReplacement = placeholderReplacement;
    }

    public String getSqlMigrationPrefix() {
        return this.sqlMigrationPrefix;
    }

    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        this.sqlMigrationPrefix = sqlMigrationPrefix;
    }

    public List<String> getSqlMigrationSuffixes() {
        return this.sqlMigrationSuffixes;
    }

    public void setSqlMigrationSuffixes(List<String> sqlMigrationSuffixes) {
        this.sqlMigrationSuffixes = sqlMigrationSuffixes;
    }

    public String getSqlMigrationSeparator() {
        return this.sqlMigrationSeparator;
    }

    public void setSqlMigrationSeparator(String sqlMigrationSeparator) {
        this.sqlMigrationSeparator = sqlMigrationSeparator;
    }

    public String getRepeatableSqlMigrationPrefix() {
        return this.repeatableSqlMigrationPrefix;
    }

    public void setRepeatableSqlMigrationPrefix(String repeatableSqlMigrationPrefix) {
        this.repeatableSqlMigrationPrefix = repeatableSqlMigrationPrefix;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public @Nullable String getUser() {
        return this.user;
    }

    public void setUser(@Nullable String user) {
        this.user = user;
    }

    public @Nullable String getPassword() {
        return this.password;
    }

    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    public @Nullable String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(@Nullable String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public @Nullable String getUrl() {
        return this.url;
    }

    public void setUrl(@Nullable String url) {
        this.url = url;
    }

    public List<String> getInitSqls() {
        return this.initSqls;
    }

    public void setInitSqls(List<String> initSqls) {
        this.initSqls = initSqls;
    }

    public boolean isBaselineOnMigrate() {
        return this.baselineOnMigrate;
    }

    public void setBaselineOnMigrate(boolean baselineOnMigrate) {
        this.baselineOnMigrate = baselineOnMigrate;
    }

    public boolean isCleanDisabled() {
        return this.cleanDisabled;
    }

    public void setCleanDisabled(boolean cleanDisabled) {
        this.cleanDisabled = cleanDisabled;
    }

    public boolean isGroup() {
        return this.group;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public boolean isMixed() {
        return this.mixed;
    }

    public void setMixed(boolean mixed) {
        this.mixed = mixed;
    }

    public boolean isOutOfOrder() {
        return this.outOfOrder;
    }

    public void setOutOfOrder(boolean outOfOrder) {
        this.outOfOrder = outOfOrder;
    }

    public boolean isSkipDefaultCallbacks() {
        return this.skipDefaultCallbacks;
    }

    public void setSkipDefaultCallbacks(boolean skipDefaultCallbacks) {
        this.skipDefaultCallbacks = skipDefaultCallbacks;
    }

    public boolean isSkipDefaultResolvers() {
        return this.skipDefaultResolvers;
    }

    public void setSkipDefaultResolvers(boolean skipDefaultResolvers) {
        this.skipDefaultResolvers = skipDefaultResolvers;
    }

    public boolean isValidateMigrationNaming() {
        return this.validateMigrationNaming;
    }

    public void setValidateMigrationNaming(boolean validateMigrationNaming) {
        this.validateMigrationNaming = validateMigrationNaming;
    }

    public boolean isValidateOnMigrate() {
        return this.validateOnMigrate;
    }

    public void setValidateOnMigrate(boolean validateOnMigrate) {
        this.validateOnMigrate = validateOnMigrate;
    }

    public String getScriptPlaceholderPrefix() {
        return this.scriptPlaceholderPrefix;
    }

    public void setScriptPlaceholderPrefix(String scriptPlaceholderPrefix) {
        this.scriptPlaceholderPrefix = scriptPlaceholderPrefix;
    }

    public String getScriptPlaceholderSuffix() {
        return this.scriptPlaceholderSuffix;
    }

    public void setScriptPlaceholderSuffix(String scriptPlaceholderSuffix) {
        this.scriptPlaceholderSuffix = scriptPlaceholderSuffix;
    }

    public @Nullable String getPowershellExecutable() {
        return this.powershellExecutable;
    }

    public void setPowershellExecutable(@Nullable String powershellExecutable) {
        this.powershellExecutable = powershellExecutable;
    }

    public boolean isExecuteInTransaction() {
        return this.executeInTransaction;
    }

    public void setExecuteInTransaction(boolean executeInTransaction) {
        this.executeInTransaction = executeInTransaction;
    }

    public String[] getLoggers() {
        return this.loggers;
    }

    public void setLoggers(String[] loggers) {
        this.loggers = loggers;
    }

    public @Nullable Boolean getBatch() {
        return this.batch;
    }

    public void setBatch(@Nullable Boolean batch) {
        this.batch = batch;
    }

    public @Nullable File getDryRunOutput() {
        return this.dryRunOutput;
    }

    public void setDryRunOutput(@Nullable File dryRunOutput) {
        this.dryRunOutput = dryRunOutput;
    }

    public String @Nullable [] getErrorOverrides() {
        return this.errorOverrides;
    }

    public void setErrorOverrides(String @Nullable [] errorOverrides) {
        this.errorOverrides = errorOverrides;
    }

    public @Nullable Boolean getStream() {
        return this.stream;
    }

    public void setStream(@Nullable Boolean stream) {
        this.stream = stream;
    }

    public Map<String, String> getJdbcProperties() {
        return this.jdbcProperties;
    }

    public void setJdbcProperties(Map<String, String> jdbcProperties) {
        this.jdbcProperties = jdbcProperties;
    }

    public @Nullable String getKerberosConfigFile() {
        return this.kerberosConfigFile;
    }

    public void setKerberosConfigFile(@Nullable String kerberosConfigFile) {
        this.kerberosConfigFile = kerberosConfigFile;
    }

    public @Nullable Boolean getOutputQueryResults() {
        return this.outputQueryResults;
    }

    public void setOutputQueryResults(@Nullable Boolean outputQueryResults) {
        this.outputQueryResults = outputQueryResults;
    }

    public @Nullable Boolean getSkipExecutingMigrations() {
        return this.skipExecutingMigrations;
    }

    public void setSkipExecutingMigrations(@Nullable Boolean skipExecutingMigrations) {
        this.skipExecutingMigrations = skipExecutingMigrations;
    }

    public List<String> getIgnoreMigrationPatterns() {
        return this.ignoreMigrationPatterns;
    }

    public void setIgnoreMigrationPatterns(List<String> ignoreMigrationPatterns) {
        this.ignoreMigrationPatterns = ignoreMigrationPatterns;
    }

    public @Nullable Boolean getDetectEncoding() {
        return this.detectEncoding;
    }

    public void setDetectEncoding(@Nullable Boolean detectEncoding) {
        this.detectEncoding = detectEncoding;
    }

    public @Nullable Boolean getCommunityDbSupportEnabled() {
        return this.communityDbSupportEnabled;
    }

    public void setCommunityDbSupportEnabled(@Nullable Boolean communityDbSupportEnabled) {
        this.communityDbSupportEnabled = communityDbSupportEnabled;
    }

    public Oracle getOracle() {
        return this.oracle;
    }

    public Postgresql getPostgresql() {
        return this.postgresql;
    }

    public Sqlserver getSqlserver() {
        return this.sqlserver;
    }

    public static class Oracle {
        private @Nullable Boolean sqlplus;
        private @Nullable Boolean sqlplusWarn;
        private @Nullable String kerberosCacheFile;
        private @Nullable String walletLocation;

        public @Nullable Boolean getSqlplus() {
            return this.sqlplus;
        }

        public void setSqlplus(@Nullable Boolean sqlplus) {
            this.sqlplus = sqlplus;
        }

        public @Nullable Boolean getSqlplusWarn() {
            return this.sqlplusWarn;
        }

        public void setSqlplusWarn(@Nullable Boolean sqlplusWarn) {
            this.sqlplusWarn = sqlplusWarn;
        }

        public @Nullable String getKerberosCacheFile() {
            return this.kerberosCacheFile;
        }

        public void setKerberosCacheFile(@Nullable String kerberosCacheFile) {
            this.kerberosCacheFile = kerberosCacheFile;
        }

        public @Nullable String getWalletLocation() {
            return this.walletLocation;
        }

        public void setWalletLocation(@Nullable String walletLocation) {
            this.walletLocation = walletLocation;
        }
    }

    public static class Postgresql {
        private @Nullable Boolean transactionalLock;

        public @Nullable Boolean getTransactionalLock() {
            return this.transactionalLock;
        }

        public void setTransactionalLock(@Nullable Boolean transactionalLock) {
            this.transactionalLock = transactionalLock;
        }
    }

    public static class Sqlserver {
        private @Nullable String kerberosLoginFile;

        public @Nullable String getKerberosLoginFile() {
            return this.kerberosLoginFile;
        }

        public void setKerberosLoginFile(@Nullable String kerberosLoginFile) {
            this.kerberosLoginFile = kerberosLoginFile;
        }
    }
}

