/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.elasticsearch.health;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.http.StatusLine;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.springframework.boot.health.contributor.AbstractHealthIndicator;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.health.contributor.Status;
import org.springframework.boot.json.JsonParser;
import org.springframework.boot.json.JsonParserFactory;
import org.springframework.util.StreamUtils;

public class ElasticsearchRestClientHealthIndicator
extends AbstractHealthIndicator {
    private static final String RED_STATUS = "red";
    private final RestClient client;
    private final JsonParser jsonParser;

    public ElasticsearchRestClientHealthIndicator(RestClient client) {
        super("Elasticsearch health check failed");
        this.client = client;
        this.jsonParser = JsonParserFactory.getJsonParser();
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        Response response = this.client.performRequest(new Request("GET", "/_cluster/health/"));
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() != 200) {
            builder.down();
            builder.withDetail("statusCode", (Object)statusLine.getStatusCode());
            builder.withDetail("reasonPhrase", (Object)statusLine.getReasonPhrase());
            return;
        }
        try (InputStream inputStream = response.getEntity().getContent();){
            this.doHealthCheck(builder, StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
        }
    }

    private void doHealthCheck(Health.Builder builder, String json) {
        Map response = this.jsonParser.parseMap(json);
        String status = (String)response.get("status");
        builder.status(RED_STATUS.equals(status) ? Status.OUT_OF_SERVICE : Status.UP);
        builder.withDetails(response);
    }
}

