/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.elasticsearch.autoconfigure.health;

import org.elasticsearch.client.RestClient;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.elasticsearch.autoconfigure.ElasticsearchRestClientAutoConfiguration;
import org.springframework.boot.elasticsearch.health.ElasticsearchRestClientHealthIndicator;
import org.springframework.boot.health.autoconfigure.contributor.CompositeHealthContributorConfiguration;
import org.springframework.boot.health.autoconfigure.contributor.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={ElasticsearchRestClientAutoConfiguration.class})
@ConditionalOnClass(value={RestClient.class, ConditionalOnEnabledHealthIndicator.class})
@ConditionalOnBean(value={RestClient.class})
@ConditionalOnEnabledHealthIndicator(value="elasticsearch")
public class ElasticsearchRestHealthContributorAutoConfiguration
extends CompositeHealthContributorConfiguration<ElasticsearchRestClientHealthIndicator, RestClient> {
    public ElasticsearchRestHealthContributorAutoConfiguration() {
        super(ElasticsearchRestClientHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"elasticsearchHealthIndicator", "elasticsearchHealthContributor"})
    public HealthContributor elasticsearchHealthContributor(ConfigurableListableBeanFactory beanFactory) {
        return (HealthContributor)this.createContributor(beanFactory, RestClient.class);
    }
}

