/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.hazelcast;

import com.hazelcast.client.config.ClientConfig;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.docker.compose.service.connection.hazelcast.HazelcastEnvironment;

class HazelcastDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<HazelcastConnectionDetails> {
    private static final int DEFAULT_PORT = 5701;

    protected HazelcastDockerComposeConnectionDetailsFactory() {
        super("hazelcast/hazelcast", "com.hazelcast.client.config.ClientConfig");
    }

    @Override
    protected HazelcastConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new HazelcastDockerComposeConnectionDetails(source.getRunningService());
    }

    static class HazelcastDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements HazelcastConnectionDetails {
        private final String host;
        private final int port;
        private final HazelcastEnvironment environment;

        HazelcastDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.host = service.host();
            this.port = service.ports().get(5701);
            this.environment = new HazelcastEnvironment(service.env());
        }

        public ClientConfig getClientConfig() {
            ClientConfig config = new ClientConfig();
            if (this.environment.getClusterName() != null) {
                config.setClusterName(this.environment.getClusterName());
            }
            config.getNetworkConfig().addAddress(new String[]{this.host + ":" + this.port});
            return config;
        }
    }
}

