/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.boot.Banner;
import org.springframework.boot.ResourceBanner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.context.config.AnsiOutputApplicationListener;
import org.springframework.boot.context.config.ConfigDataEnvironmentPostProcessor;
import org.springframework.boot.context.logging.ClasspathLoggingApplicationListener;
import org.springframework.boot.context.logging.LoggingApplicationListener;
import org.springframework.boot.devtools.RemoteUrlPropertyExtractor;
import org.springframework.boot.devtools.remote.client.RemoteClientConfiguration;
import org.springframework.boot.devtools.restart.RestartInitializer;
import org.springframework.boot.devtools.restart.RestartScopeInitializer;
import org.springframework.boot.devtools.restart.Restarter;
import org.springframework.boot.env.EnvironmentPostProcessorApplicationListener;
import org.springframework.boot.env.EnvironmentPostProcessorsFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public final class RemoteSpringApplication {
    private RemoteSpringApplication() {
    }

    private void run(String[] args) {
        Restarter.initialize(args, RestartInitializer.NONE);
        SpringApplication application = new SpringApplication(new Class[]{RemoteClientConfiguration.class});
        application.setWebApplicationType(WebApplicationType.NONE);
        application.setBanner(this.getBanner());
        application.setInitializers(this.getInitializers());
        application.setListeners(this.getListeners());
        application.run(args);
        this.waitIndefinitely();
    }

    private Collection<ApplicationContextInitializer<?>> getInitializers() {
        ArrayList initializers = new ArrayList();
        initializers.add(new RestartScopeInitializer());
        return initializers;
    }

    private Collection<ApplicationListener<?>> getListeners() {
        ArrayList listeners = new ArrayList();
        listeners.add((ApplicationListener<?>)new AnsiOutputApplicationListener());
        listeners.add((ApplicationListener<?>)new EnvironmentPostProcessorApplicationListener(EnvironmentPostProcessorsFactory.of((Class[])new Class[]{ConfigDataEnvironmentPostProcessor.class})));
        listeners.add((ApplicationListener<?>)new ClasspathLoggingApplicationListener());
        listeners.add((ApplicationListener<?>)new LoggingApplicationListener());
        listeners.add(new RemoteUrlPropertyExtractor());
        return listeners;
    }

    private Banner getBanner() {
        ClassPathResource banner = new ClassPathResource("remote-banner.txt", RemoteSpringApplication.class);
        return new ResourceBanner((Resource)banner);
    }

    private void waitIndefinitely() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        new RemoteSpringApplication().run(args);
    }
}

