/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.dependency.tools;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.springframework.boot.dependency.tools.AbstractDependencies;
import org.springframework.boot.dependency.tools.Dependency;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PomDependencies
extends AbstractDependencies {
    public PomDependencies(InputStream effectivePomInputStream) {
        try {
            Document effectivePom = this.readDocument(effectivePomInputStream);
            for (Dependency dependency : this.readDependencies(effectivePom)) {
                this.add(new AbstractDependencies.ArtifactAndGroupId(dependency), dependency);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document readDocument(InputStream inputStream) throws Exception {
        if (inputStream == null) {
            return null;
        }
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            document.getDocumentElement().normalize();
            Document document2 = document;
            return document2;
        }
        finally {
            inputStream.close();
        }
    }

    private List<Dependency> readDependencies(Document document) throws Exception {
        Element element = (Element)document.getElementsByTagName("project").item(0);
        element = (Element)element.getElementsByTagName("dependencyManagement").item(0);
        element = (Element)element.getElementsByTagName("dependencies").item(0);
        NodeList nodes = element.getChildNodes();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            dependencies.add(this.createDependency((Element)node));
        }
        return dependencies;
    }

    private Dependency createDependency(Element element) throws Exception {
        String groupId = this.getTextContent(element, "groupId");
        String artifactId = this.getTextContent(element, "artifactId");
        String version = this.getTextContent(element, "version");
        List<Dependency.Exclusion> exclusions = this.createExclusions(element.getElementsByTagName("exclusions"));
        return new Dependency(groupId, artifactId, version, exclusions);
    }

    private List<Dependency.Exclusion> createExclusions(NodeList exclusion) {
        if (exclusion == null || exclusion.getLength() == 0) {
            return Collections.emptyList();
        }
        return this.createExclusions(exclusion.item(0));
    }

    private List<Dependency.Exclusion> createExclusions(Node item) {
        ArrayList<Dependency.Exclusion> exclusions = new ArrayList<Dependency.Exclusion>();
        NodeList children = item.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            exclusions.add(this.createExclusion((Element)child));
        }
        return exclusions;
    }

    private Dependency.Exclusion createExclusion(Element element) {
        String groupId = this.getTextContent(element, "groupId");
        String artifactId = this.getTextContent(element, "artifactId");
        return new Dependency.Exclusion(groupId, artifactId);
    }

    private String getTextContent(Element element, String tagName) {
        return element.getElementsByTagName(tagName).item(0).getTextContent();
    }
}

