/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.couchbase.autoconfigure.health;

import com.couchbase.client.java.Cluster;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.couchbase.autoconfigure.CouchbaseAutoConfiguration;
import org.springframework.boot.couchbase.autoconfigure.health.CouchbaseReactiveHealthContributorAutoConfiguration;
import org.springframework.boot.couchbase.health.CouchbaseHealthIndicator;
import org.springframework.boot.health.autoconfigure.contributor.CompositeHealthContributorConfiguration;
import org.springframework.boot.health.autoconfigure.contributor.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={CouchbaseAutoConfiguration.class, CouchbaseReactiveHealthContributorAutoConfiguration.class})
@ConditionalOnClass(value={Cluster.class, CouchbaseHealthIndicator.class, ConditionalOnEnabledHealthIndicator.class})
@ConditionalOnBean(value={Cluster.class})
@ConditionalOnEnabledHealthIndicator(value="couchbase")
public final class CouchbaseHealthContributorAutoConfiguration
extends CompositeHealthContributorConfiguration<CouchbaseHealthIndicator, Cluster> {
    CouchbaseHealthContributorAutoConfiguration() {
        super(CouchbaseHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"couchbaseHealthIndicator", "couchbaseHealthContributor"})
    HealthContributor couchbaseHealthContributor(ConfigurableListableBeanFactory beanFactory) {
        return (HealthContributor)this.createContributor(beanFactory, Cluster.class);
    }
}

