/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.springframework.boot.configurationprocessor.MetadataCollector;
import org.springframework.boot.configurationprocessor.MetadataStore;
import org.springframework.boot.configurationprocessor.TypeUtils;
import org.springframework.boot.configurationprocessor.metadata.ItemMetadata;

class MetadataCollectors {
    private final ProcessingEnvironment processingEnvironment;
    private final TypeUtils typeUtils;
    private final MetadataStore metadataStore;
    private final MetadataCollector metadataCollector;
    private final Set<String> processedSourceTypes = new HashSet<String>();
    private final Map<TypeElement, MetadataCollector> metadataTypeCollectors = new HashMap<TypeElement, MetadataCollector>();

    MetadataCollectors(ProcessingEnvironment processingEnvironment, TypeUtils typeUtils) {
        this.processingEnvironment = processingEnvironment;
        this.typeUtils = typeUtils;
        this.metadataStore = new MetadataStore(this.processingEnvironment, this.typeUtils);
        this.metadataCollector = new MetadataCollector(this::shouldBeMerged, this.metadataStore.readMetadata());
    }

    void processing(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getRootElements()) {
            if (!(element instanceof TypeElement)) continue;
            this.processedSourceTypes.add(this.typeUtils.getQualifiedName(element));
        }
    }

    MetadataCollector getModuleMetadataCollector() {
        return this.metadataCollector;
    }

    MetadataCollector getMetadataCollector(TypeElement element) {
        return this.metadataTypeCollectors.computeIfAbsent(element, ignored -> new MetadataCollector(this::shouldBeMerged, this.metadataStore.readMetadata(element)));
    }

    Set<TypeElement> getSourceTypes() {
        return this.metadataTypeCollectors.keySet();
    }

    private boolean shouldBeMerged(ItemMetadata itemMetadata) {
        String sourceType = itemMetadata.getSourceType();
        return sourceType != null && !this.deletedInCurrentBuild(sourceType) && !this.processedInCurrentBuild(sourceType);
    }

    private boolean deletedInCurrentBuild(String sourceType) {
        return this.processingEnvironment.getElementUtils().getTypeElement(sourceType.replace('$', '.')) == null;
    }

    private boolean processedInCurrentBuild(String sourceType) {
        return this.processedSourceTypes.contains(sourceType);
    }
}

