/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.LinkedHashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.boot.configurationprocessor.metadata.ConfigurationMetadata;
import org.springframework.boot.configurationprocessor.metadata.ItemMetadata;

public class JsonMarshaller {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final int BUFFER_SIZE = 4098;

    public void write(ConfigurationMetadata metadata, OutputStream outputStream) throws IOException {
        JSONObject object = new JSONObject();
        object.put("groups", (Object)this.toJsonArray(metadata, ItemMetadata.ItemType.GROUP));
        object.put("properties", (Object)this.toJsonArray(metadata, ItemMetadata.ItemType.PROPERTY));
        outputStream.write(object.toString(2).getBytes(UTF_8));
    }

    private JSONArray toJsonArray(ConfigurationMetadata metadata, ItemMetadata.ItemType itemType) {
        JSONArray jsonArray = new JSONArray();
        for (ItemMetadata item : metadata.getItems()) {
            if (!item.isOfItemType(itemType)) continue;
            jsonArray.put((Object)this.toJsonObject(item));
        }
        return jsonArray;
    }

    private JSONObject toJsonObject(ItemMetadata item) {
        JSONOrderedObject jsonObject = new JSONOrderedObject();
        jsonObject.put("name", item.getName());
        this.putIfPresent(jsonObject, "type", item.getType());
        this.putIfPresent(jsonObject, "description", item.getDescription());
        this.putIfPresent(jsonObject, "sourceType", item.getSourceType());
        this.putIfPresent(jsonObject, "sourceMethod", item.getSourceMethod());
        Object defaultValue = item.getDefaultValue();
        if (defaultValue != null) {
            this.putDefaultValue(jsonObject, defaultValue);
        }
        if (item.isDeprecated()) {
            jsonObject.put("deprecated", true);
        }
        return jsonObject;
    }

    private void putIfPresent(JSONObject jsonObject, String name, Object value) {
        if (value != null) {
            jsonObject.put(name, value);
        }
    }

    private void putDefaultValue(JSONObject jsonObject, Object value) {
        Object defaultValue = value;
        if (value.getClass().isArray()) {
            JSONArray array = new JSONArray();
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                array.put(Array.get(value, i));
            }
            defaultValue = array;
        }
        jsonObject.put("defaultValue", defaultValue);
    }

    public ConfigurationMetadata read(InputStream inputStream) throws IOException {
        JSONArray properties;
        ConfigurationMetadata metadata = new ConfigurationMetadata();
        JSONObject object = new JSONObject(this.toString(inputStream));
        JSONArray groups = object.optJSONArray("groups");
        if (groups != null) {
            for (int i = 0; i < groups.length(); ++i) {
                metadata.add(this.toItemMetadata((JSONObject)groups.get(i), ItemMetadata.ItemType.GROUP));
            }
        }
        if ((properties = object.optJSONArray("properties")) != null) {
            for (int i = 0; i < properties.length(); ++i) {
                metadata.add(this.toItemMetadata((JSONObject)properties.get(i), ItemMetadata.ItemType.PROPERTY));
            }
        }
        return metadata;
    }

    private ItemMetadata toItemMetadata(JSONObject object, ItemMetadata.ItemType itemType) {
        String name = object.getString("name");
        String type = object.optString("type", null);
        String description = object.optString("description", null);
        String sourceType = object.optString("sourceType", null);
        String sourceMethod = object.optString("sourceMethod", null);
        Object defaultValue = this.readDefaultValue(object);
        boolean deprecated = object.optBoolean("deprecated");
        return new ItemMetadata(itemType, name, null, type, sourceType, sourceMethod, description, defaultValue, deprecated);
    }

    private Object readDefaultValue(JSONObject object) {
        Object defaultValue = object.opt("defaultValue");
        if (defaultValue instanceof JSONArray) {
            JSONArray array = (JSONArray)defaultValue;
            Object[] content = new Object[array.length()];
            for (int i = 0; i < array.length(); ++i) {
                content[i] = array.get(i);
            }
            return content;
        }
        return defaultValue;
    }

    private String toString(InputStream inputStream) throws IOException {
        int bytesRead;
        StringBuilder out = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(inputStream, UTF_8);
        char[] buffer = new char[4098];
        while ((bytesRead = reader.read(buffer)) != -1) {
            out.append(buffer, 0, bytesRead);
        }
        return out.toString();
    }

    private static class JSONOrderedObject
    extends JSONObject {
        private Set<String> keys = new LinkedHashSet<String>();

        private JSONOrderedObject() {
        }

        public JSONObject put(String key, Object value) throws JSONException {
            this.keys.add(key);
            return super.put(key, value);
        }

        public Set keySet() {
            return this.keys;
        }
    }
}

