/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.init;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.springframework.boot.cli.command.init.Dependency;
import org.springframework.boot.cli.command.init.InitializrService;
import org.springframework.boot.cli.command.init.InitializrServiceMetadata;
import org.springframework.boot.cli.command.init.ProjectType;

class ServiceCapabilitiesReportGenerator {
    private static final String NEW_LINE = System.lineSeparator();
    private final InitializrService initializrService;

    ServiceCapabilitiesReportGenerator(InitializrService initializrService) {
        this.initializrService = initializrService;
    }

    String generate(String url) throws IOException {
        Object content = this.initializrService.loadServiceCapabilities(url);
        if (content instanceof InitializrServiceMetadata) {
            InitializrServiceMetadata metadata = (InitializrServiceMetadata)content;
            return this.generateHelp(url, metadata);
        }
        return content.toString();
    }

    private String generateHelp(String url, InitializrServiceMetadata metadata) {
        String header = "Capabilities of " + url;
        StringBuilder report = new StringBuilder();
        report.append("=".repeat(header.length())).append(NEW_LINE);
        report.append(header).append(NEW_LINE);
        report.append("=".repeat(header.length())).append(NEW_LINE);
        report.append(NEW_LINE);
        this.reportAvailableDependencies(metadata, report);
        report.append(NEW_LINE);
        this.reportAvailableProjectTypes(metadata, report);
        report.append(NEW_LINE);
        this.reportDefaults(report, metadata);
        return report.toString();
    }

    private void reportAvailableDependencies(InitializrServiceMetadata metadata, StringBuilder report) {
        report.append("Available dependencies:").append(NEW_LINE);
        report.append("-----------------------").append(NEW_LINE);
        List<Dependency> dependencies = this.getSortedDependencies(metadata);
        for (Dependency dependency : dependencies) {
            report.append(dependency.getId()).append(" - ").append(dependency.getName());
            if (dependency.getDescription() != null) {
                report.append(": ").append(dependency.getDescription());
            }
            report.append(NEW_LINE);
        }
    }

    private List<Dependency> getSortedDependencies(InitializrServiceMetadata metadata) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(metadata.getDependencies());
        dependencies.sort(Comparator.comparing(Dependency::getId));
        return dependencies;
    }

    private void reportAvailableProjectTypes(InitializrServiceMetadata metadata, StringBuilder report) {
        report.append("Available project types:").append(NEW_LINE);
        report.append("------------------------").append(NEW_LINE);
        TreeSet entries = new TreeSet(Map.Entry.comparingByKey());
        entries.addAll(metadata.getProjectTypes().entrySet());
        for (Map.Entry entry : entries) {
            ProjectType type = (ProjectType)entry.getValue();
            report.append((String)entry.getKey()).append(" -  ").append(type.getName());
            if (!type.getTags().isEmpty()) {
                this.reportTags(report, type);
            }
            if (type.isDefaultType()) {
                report.append(" (default)");
            }
            report.append(NEW_LINE);
        }
    }

    private void reportTags(StringBuilder report, ProjectType type) {
        Map<String, String> tags = type.getTags();
        Iterator<Map.Entry<String, String>> iterator = tags.entrySet().iterator();
        report.append(" [");
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            report.append(entry.getKey()).append(":").append(entry.getValue());
            if (!iterator.hasNext()) continue;
            report.append(", ");
        }
        report.append("]");
    }

    private void reportDefaults(StringBuilder report, InitializrServiceMetadata metadata) {
        report.append("Defaults:").append(NEW_LINE);
        report.append("---------").append(NEW_LINE);
        ArrayList<String> defaultsKeys = new ArrayList<String>(metadata.getDefaults().keySet());
        Collections.sort(defaultsKeys);
        for (String defaultsKey : defaultsKeys) {
            String defaultsValue = metadata.getDefaults().get(defaultsKey);
            report.append(defaultsKey).append(": ").append(defaultsValue).append(NEW_LINE);
        }
    }
}

