/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.encodepassword;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.springframework.boot.cli.command.HelpExample;
import org.springframework.boot.cli.command.OptionParsingCommand;
import org.springframework.boot.cli.command.options.OptionHandler;
import org.springframework.boot.cli.command.status.ExitStatus;
import org.springframework.boot.cli.util.Log;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.util.StringUtils;

public class EncodePasswordCommand
extends OptionParsingCommand {
    private static final Map<String, Supplier<PasswordEncoder>> ENCODERS;

    public EncodePasswordCommand() {
        super("encodepassword", "Encode a password for use with Spring Security", new EncodePasswordOptionHandler());
    }

    @Override
    public String getUsageHelp() {
        return "[options] <password to encode>";
    }

    @Override
    public Collection<HelpExample> getExamples() {
        ArrayList<HelpExample> examples = new ArrayList<HelpExample>();
        examples.add(new HelpExample("To encode a password with the default (bcrypt) encoder", "spring encodepassword mypassword"));
        examples.add(new HelpExample("To encode a password with pbkdf2", "spring encodepassword -a pbkdf2 mypassword"));
        return examples;
    }

    static {
        LinkedHashMap<String, Supplier<PasswordEncoder>> encoders = new LinkedHashMap<String, Supplier<PasswordEncoder>>();
        encoders.put("default", PasswordEncoderFactories::createDelegatingPasswordEncoder);
        encoders.put("bcrypt", BCryptPasswordEncoder::new);
        encoders.put("pbkdf2", Pbkdf2PasswordEncoder::defaultsForSpringSecurity_v5_8);
        ENCODERS = Collections.unmodifiableMap(encoders);
    }

    private static final class EncodePasswordOptionHandler
    extends OptionHandler {
        private OptionSpec<String> algorithm;

        private EncodePasswordOptionHandler() {
        }

        @Override
        protected void options() {
            this.algorithm = this.option(Arrays.asList("algorithm", "a"), "The algorithm to use. Supported algorithms: " + StringUtils.collectionToDelimitedString(ENCODERS.keySet(), (String)", ") + ". The default algorithm uses bcrypt").withRequiredArg().defaultsTo((Object)"default", (Object[])new String[0]);
        }

        @Override
        protected ExitStatus run(OptionSet options) {
            if (options.nonOptionArguments().size() != 1) {
                Log.error("A single password option must be provided");
                return ExitStatus.ERROR;
            }
            String algorithm = (String)options.valueOf(this.algorithm);
            String password = (String)options.nonOptionArguments().get(0);
            Supplier<PasswordEncoder> encoder = ENCODERS.get(algorithm);
            if (encoder == null) {
                Log.error("Unknown algorithm, valid options are: " + StringUtils.collectionToCommaDelimitedString(ENCODERS.keySet()));
                return ExitStatus.ERROR;
            }
            Log.info(encoder.get().encode((CharSequence)password));
            return ExitStatus.OK;
        }
    }
}

