/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.options;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import joptsimple.OptionSet;
import org.springframework.boot.cli.util.ResourceUtils;
import org.springframework.util.Assert;

public class SourceOptions {
    private final List<String> sources;
    private final List<?> args;

    public SourceOptions(OptionSet options) {
        this(options, null);
    }

    public SourceOptions(List<?> arguments) {
        this(arguments, null);
    }

    public SourceOptions(OptionSet optionSet, ClassLoader classLoader) {
        this(optionSet.nonOptionArguments(), classLoader);
    }

    private SourceOptions(List<?> nonOptionArguments, ClassLoader classLoader) {
        ArrayList<String> sources = new ArrayList<String>();
        int sourceArgCount = 0;
        for (Object option : nonOptionArguments) {
            if (!(option instanceof String)) continue;
            String filename = (String)option;
            if ("--".equals(filename)) break;
            List<String> urls = ResourceUtils.getUrls(filename, classLoader);
            for (String url : urls) {
                if (!url.endsWith(".groovy") && !url.endsWith(".java")) continue;
                sources.add(url);
            }
            if (!filename.endsWith(".groovy") && !filename.endsWith(".java")) continue;
            if (urls.isEmpty()) {
                throw new IllegalArgumentException("Can't find " + filename);
            }
            ++sourceArgCount;
        }
        this.args = Collections.unmodifiableList(nonOptionArguments.subList(sourceArgCount, nonOptionArguments.size()));
        Assert.isTrue((sources.size() > 0 ? 1 : 0) != 0, (String)"Please specify at least one file");
        this.sources = Collections.unmodifiableList(sources);
    }

    public List<?> getArgs() {
        return this.args;
    }

    public String[] getArgsArray() {
        return this.args.toArray(new String[this.args.size()]);
    }

    public List<String> getSources() {
        return this.sources;
    }

    public String[] getSourcesArray() {
        return this.sources.toArray(new String[this.sources.size()]);
    }
}

