/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cache.actuate.endpoint;

import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.OptionalParameter;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.EndpointWebExtension;
import org.springframework.boot.cache.actuate.endpoint.CachesEndpoint;
import org.springframework.boot.cache.actuate.endpoint.NonUniqueCacheException;

@EndpointWebExtension(endpoint=CachesEndpoint.class)
public class CachesEndpointWebExtension {
    private final CachesEndpoint delegate;

    public CachesEndpointWebExtension(CachesEndpoint delegate) {
        this.delegate = delegate;
    }

    @ReadOperation
    public WebEndpointResponse<CachesEndpoint.CacheEntryDescriptor> cache(@Selector String cache, @OptionalParameter String cacheManager) {
        try {
            CachesEndpoint.CacheEntryDescriptor entry = this.delegate.cache(cache, cacheManager);
            int status = entry != null ? 200 : 404;
            return new WebEndpointResponse((Object)entry, status);
        }
        catch (NonUniqueCacheException ex) {
            return new WebEndpointResponse(400);
        }
    }

    @DeleteOperation
    public WebEndpointResponse<Void> clearCache(@Selector String cache, @OptionalParameter String cacheManager) {
        try {
            boolean cleared = this.delegate.clearCache(cache, cacheManager);
            int status = cleared ? 204 : 404;
            return new WebEndpointResponse(status);
        }
        catch (NonUniqueCacheException ex) {
            return new WebEndpointResponse(400);
        }
    }
}

