/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.net.URIBuilder;
import org.springframework.boot.buildpack.platform.docker.DockerLog;
import org.springframework.boot.buildpack.platform.docker.ExportedImageTar;
import org.springframework.boot.buildpack.platform.docker.LoadImageUpdateEvent;
import org.springframework.boot.buildpack.platform.docker.LogUpdateEvent;
import org.springframework.boot.buildpack.platform.docker.ProgressUpdateEvent;
import org.springframework.boot.buildpack.platform.docker.PullImageUpdateEvent;
import org.springframework.boot.buildpack.platform.docker.PushImageUpdateEvent;
import org.springframework.boot.buildpack.platform.docker.UpdateListener;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerConnectionConfiguration;
import org.springframework.boot.buildpack.platform.docker.transport.HttpTransport;
import org.springframework.boot.buildpack.platform.docker.type.ApiVersion;
import org.springframework.boot.buildpack.platform.docker.type.ContainerConfig;
import org.springframework.boot.buildpack.platform.docker.type.ContainerContent;
import org.springframework.boot.buildpack.platform.docker.type.ContainerReference;
import org.springframework.boot.buildpack.platform.docker.type.ContainerStatus;
import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.boot.buildpack.platform.docker.type.ImageArchive;
import org.springframework.boot.buildpack.platform.docker.type.ImagePlatform;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.docker.type.VolumeName;
import org.springframework.boot.buildpack.platform.io.IOBiConsumer;
import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.boot.buildpack.platform.json.JsonStream;
import org.springframework.boot.buildpack.platform.json.SharedObjectMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DockerApi {
    private static final List<String> FORCE_PARAMS = Collections.unmodifiableList(Arrays.asList("force", "1"));
    static final ApiVersion API_VERSION = ApiVersion.of(1, 24);
    static final ApiVersion PLATFORM_API_VERSION = ApiVersion.of(1, 41);
    static final ApiVersion UNKNOWN_API_VERSION = ApiVersion.of(0, 0);
    static final String API_VERSION_HEADER_NAME = "API-Version";
    private final HttpTransport http;
    private final JsonStream jsonStream;
    private final ImageApi image;
    private final ContainerApi container;
    private final VolumeApi volume;
    private final SystemApi system;
    private volatile ApiVersion apiVersion = null;

    public DockerApi() {
        this(HttpTransport.create(null), DockerLog.toSystemOut());
    }

    public DockerApi(DockerConnectionConfiguration connectionConfiguration, DockerLog log) {
        this(HttpTransport.create(connectionConfiguration), log);
    }

    DockerApi(HttpTransport http, DockerLog log) {
        Assert.notNull((Object)http, (String)"'http' must not be null");
        Assert.notNull((Object)log, (String)"'log' must not be null");
        this.http = http;
        this.jsonStream = new JsonStream(SharedObjectMapper.get());
        this.image = new ImageApi();
        this.container = new ContainerApi();
        this.volume = new VolumeApi();
        this.system = new SystemApi(log);
    }

    private HttpTransport http() {
        return this.http;
    }

    private JsonStream jsonStream() {
        return this.jsonStream;
    }

    private URI buildUrl(String path, Collection<?> params) {
        return this.buildUrl(API_VERSION, path, params != null ? params.toArray() : null);
    }

    private URI buildUrl(String path, Object ... params) {
        return this.buildUrl(API_VERSION, path, params);
    }

    private URI buildUrl(ApiVersion apiVersion, String path, Object ... params) {
        this.verifyApiVersion(apiVersion);
        try {
            URIBuilder builder = new URIBuilder("/v" + String.valueOf(apiVersion) + path);
            if (params != null) {
                int param = 0;
                while (param < params.length) {
                    builder.addParameter(Objects.toString(params[param++]), Objects.toString(params[param++]));
                }
            }
            return builder.build();
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void verifyApiVersion(ApiVersion minimumVersion) {
        ApiVersion actualVersion = this.getApiVersion();
        Assert.state((actualVersion.equals(UNKNOWN_API_VERSION) || actualVersion.supports(minimumVersion) ? 1 : 0) != 0, () -> "Docker API version must be at least " + String.valueOf(minimumVersion) + " to support this feature, but current API version is " + String.valueOf(actualVersion));
    }

    private ApiVersion getApiVersion() {
        ApiVersion apiVersion = this.apiVersion;
        if (this.apiVersion == null) {
            this.apiVersion = apiVersion = this.system.getApiVersion();
        }
        return apiVersion;
    }

    public ImageApi image() {
        return this.image;
    }

    public ContainerApi container() {
        return this.container;
    }

    public VolumeApi volume() {
        return this.volume;
    }

    SystemApi system() {
        return this.system;
    }

    public class ImageApi {
        ImageApi() {
        }

        public Image pull(ImageReference reference, ImagePlatform platform, UpdateListener<PullImageUpdateEvent> listener) throws IOException {
            return this.pull(reference, platform, listener, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Image pull(ImageReference reference, ImagePlatform platform, UpdateListener<PullImageUpdateEvent> listener, String registryAuth) throws IOException {
            Assert.notNull((Object)reference, (String)"'reference' must not be null");
            Assert.notNull(listener, (String)"'listener' must not be null");
            URI createUri = platform != null ? DockerApi.this.buildUrl(PLATFORM_API_VERSION, "/images/create", "fromImage", reference, "platform", platform) : DockerApi.this.buildUrl("/images/create", "fromImage", reference);
            DigestCaptureUpdateListener digestCapture = new DigestCaptureUpdateListener();
            listener.onStart();
            try {
                try (HttpTransport.Response response = DockerApi.this.http().post(createUri, registryAuth);){
                    DockerApi.this.jsonStream().get(response.getContent(), PullImageUpdateEvent.class, event -> {
                        digestCapture.onUpdate((ProgressUpdateEvent)event);
                        listener.onUpdate((PullImageUpdateEvent)event);
                    });
                }
                Image image = this.inspect(platform != null ? PLATFORM_API_VERSION : API_VERSION, reference);
                return image;
            }
            finally {
                listener.onFinish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void push(ImageReference reference, UpdateListener<PushImageUpdateEvent> listener, String registryAuth) throws IOException {
            Assert.notNull((Object)reference, (String)"'reference' must not be null");
            Assert.notNull(listener, (String)"'listener' must not be null");
            URI pushUri = DockerApi.this.buildUrl("/images/" + String.valueOf(reference) + "/push", new Object[0]);
            ErrorCaptureUpdateListener errorListener = new ErrorCaptureUpdateListener();
            listener.onStart();
            try (HttpTransport.Response response = DockerApi.this.http().post(pushUri, registryAuth);){
                DockerApi.this.jsonStream().get(response.getContent(), PushImageUpdateEvent.class, event -> {
                    errorListener.onUpdate((PushImageUpdateEvent)event);
                    listener.onUpdate((PushImageUpdateEvent)event);
                });
            }
            finally {
                listener.onFinish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load(ImageArchive archive, UpdateListener<LoadImageUpdateEvent> listener) throws IOException {
            Assert.notNull((Object)archive, (String)"'archive' must not be null");
            Assert.notNull(listener, (String)"'listener' must not be null");
            URI loadUri = DockerApi.this.buildUrl("/images/load", new Object[0]);
            LoadImageUpdateListener streamListener = new LoadImageUpdateListener(archive);
            listener.onStart();
            try {
                try (HttpTransport.Response response = DockerApi.this.http().post(loadUri, "application/x-tar", archive::writeTo);){
                    DockerApi.this.jsonStream().get(response.getContent(), LoadImageUpdateEvent.class, event -> {
                        streamListener.onUpdate((LoadImageUpdateEvent)event);
                        listener.onUpdate((LoadImageUpdateEvent)event);
                    });
                }
                streamListener.assertValidResponseReceived();
            }
            finally {
                listener.onFinish();
            }
        }

        public void exportLayers(ImageReference reference, IOBiConsumer<String, TarArchive> exports) throws IOException {
            Assert.notNull((Object)reference, (String)"'reference' must not be null");
            Assert.notNull(exports, (String)"'exports' must not be null");
            URI uri = DockerApi.this.buildUrl("/images/" + String.valueOf(reference) + "/get", new Object[0]);
            try (HttpTransport.Response response = DockerApi.this.http().get(uri);
                 ExportedImageTar exportedImageTar = new ExportedImageTar(reference, response.getContent());){
                exportedImageTar.exportLayers(exports);
            }
        }

        public void remove(ImageReference reference, boolean force) throws IOException {
            Assert.notNull((Object)reference, (String)"'reference' must not be null");
            Collection<String> params = force ? FORCE_PARAMS : Collections.emptySet();
            URI uri = DockerApi.this.buildUrl("/images/" + String.valueOf(reference), params);
            DockerApi.this.http().delete(uri).close();
        }

        public Image inspect(ImageReference reference) throws IOException {
            return this.inspect(API_VERSION, reference);
        }

        private Image inspect(ApiVersion apiVersion, ImageReference reference) throws IOException {
            Assert.notNull((Object)reference, (String)"'reference' must not be null");
            URI imageUri = DockerApi.this.buildUrl(apiVersion, "/images/" + String.valueOf(reference) + "/json", new Object[0]);
            try (HttpTransport.Response response = DockerApi.this.http().get(imageUri);){
                Image image = Image.of(response.getContent());
                return image;
            }
        }

        public void tag(ImageReference sourceReference, ImageReference targetReference) throws IOException {
            Assert.notNull((Object)sourceReference, (String)"'sourceReference' must not be null");
            Assert.notNull((Object)targetReference, (String)"'targetReference' must not be null");
            String tag = targetReference.getTag();
            String path = "/images/" + String.valueOf(sourceReference) + "/tag";
            URI uri = tag != null ? DockerApi.this.buildUrl(path, "repo", targetReference.inTaglessForm(), "tag", tag) : DockerApi.this.buildUrl(path, "repo", targetReference);
            DockerApi.this.http().post(uri).close();
        }
    }

    public class ContainerApi {
        ContainerApi() {
        }

        public ContainerReference create(ContainerConfig config, ImagePlatform platform, ContainerContent ... contents) throws IOException {
            Assert.notNull((Object)config, (String)"'config' must not be null");
            Assert.noNullElements((Object[])contents, (String)"'contents' must not contain null elements");
            ContainerReference containerReference = this.createContainer(config, platform);
            for (ContainerContent content : contents) {
                this.uploadContainerContent(containerReference, content);
            }
            return containerReference;
        }

        private ContainerReference createContainer(ContainerConfig config, ImagePlatform platform) throws IOException {
            URI createUri = platform != null ? DockerApi.this.buildUrl(PLATFORM_API_VERSION, "/containers/create", "platform", platform) : DockerApi.this.buildUrl("/containers/create", new Object[0]);
            try (HttpTransport.Response response = DockerApi.this.http().post(createUri, "application/json", config::writeTo);){
                ContainerReference containerReference = ContainerReference.of(SharedObjectMapper.get().readTree(response.getContent()).at("/Id").asText());
                return containerReference;
            }
        }

        private void uploadContainerContent(ContainerReference reference, ContainerContent content) throws IOException {
            URI uri = DockerApi.this.buildUrl("/containers/" + String.valueOf(reference) + "/archive", "path", content.getDestinationPath());
            DockerApi.this.http().put(uri, "application/x-tar", content.getArchive()::writeTo).close();
        }

        public void start(ContainerReference reference) throws IOException {
            Assert.notNull((Object)reference, (String)"'reference' must not be null");
            URI uri = DockerApi.this.buildUrl("/containers/" + String.valueOf(reference) + "/start", new Object[0]);
            DockerApi.this.http().post(uri).close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void logs(ContainerReference reference, UpdateListener<LogUpdateEvent> listener) throws IOException {
            Assert.notNull((Object)reference, (String)"'reference' must not be null");
            Assert.notNull(listener, (String)"'listener' must not be null");
            Object[] params = new Object[]{"stdout", "1", "stderr", "1", "follow", "1"};
            URI uri = DockerApi.this.buildUrl("/containers/" + String.valueOf(reference) + "/logs", params);
            listener.onStart();
            try (HttpTransport.Response response = DockerApi.this.http().get(uri);){
                LogUpdateEvent.readAll(response.getContent(), listener::onUpdate);
            }
            finally {
                listener.onFinish();
            }
        }

        public ContainerStatus wait(ContainerReference reference) throws IOException {
            Assert.notNull((Object)reference, (String)"'reference' must not be null");
            URI uri = DockerApi.this.buildUrl("/containers/" + String.valueOf(reference) + "/wait", new Object[0]);
            try (HttpTransport.Response response = DockerApi.this.http().post(uri);){
                ContainerStatus containerStatus = ContainerStatus.of(response.getContent());
                return containerStatus;
            }
        }

        public void remove(ContainerReference reference, boolean force) throws IOException {
            Assert.notNull((Object)reference, (String)"'reference' must not be null");
            Collection<String> params = force ? FORCE_PARAMS : Collections.emptySet();
            URI uri = DockerApi.this.buildUrl("/containers/" + String.valueOf(reference), params);
            DockerApi.this.http().delete(uri).close();
        }
    }

    public class VolumeApi {
        VolumeApi() {
        }

        public void delete(VolumeName name, boolean force) throws IOException {
            Assert.notNull((Object)name, (String)"'name' must not be null");
            Collection<String> params = force ? FORCE_PARAMS : Collections.emptySet();
            URI uri = DockerApi.this.buildUrl("/volumes/" + String.valueOf(name), params);
            DockerApi.this.http().delete(uri).close();
        }
    }

    class SystemApi {
        private final DockerLog log;

        SystemApi(DockerLog log) {
            this.log = log;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        ApiVersion getApiVersion() {
            try {
                URI uri = new URIBuilder("/_ping").build();
                try (HttpTransport.Response response = DockerApi.this.http().head(uri);){
                    Header apiVersionHeader = response.getHeader(DockerApi.API_VERSION_HEADER_NAME);
                    if (apiVersionHeader == null) return UNKNOWN_API_VERSION;
                    ApiVersion apiVersion = ApiVersion.parse(apiVersionHeader.getValue());
                    return apiVersion;
                }
                catch (Exception ex) {
                    this.log.log("Warning: Failed to determine Docker API version: " + ex.getMessage());
                }
                return UNKNOWN_API_VERSION;
            }
            catch (URISyntaxException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static final class ErrorCaptureUpdateListener
    implements UpdateListener<PushImageUpdateEvent> {
        private ErrorCaptureUpdateListener() {
        }

        @Override
        public void onUpdate(PushImageUpdateEvent event) {
            Assert.state((event.getErrorDetail() == null ? 1 : 0) != 0, () -> "Error response received when pushing image: " + event.getErrorDetail().getMessage());
        }
    }

    private static final class LoadImageUpdateListener
    implements UpdateListener<LoadImageUpdateEvent> {
        private final ImageArchive archive;
        private String stream;

        private LoadImageUpdateListener(ImageArchive archive) {
            this.archive = archive;
        }

        @Override
        public void onUpdate(LoadImageUpdateEvent event) {
            Assert.state((event.getErrorDetail() == null ? 1 : 0) != 0, () -> "Error response received when loading image" + this.image() + ": " + String.valueOf(event.getErrorDetail()));
            this.stream = event.getStream();
        }

        private String image() {
            ImageReference tag = this.archive.getTag();
            return tag != null ? " \"" + String.valueOf(tag) + "\"" : "";
        }

        private void assertValidResponseReceived() {
            Assert.state((boolean)StringUtils.hasText((String)this.stream), () -> "Invalid response received when loading image" + this.image());
        }
    }

    private static final class DigestCaptureUpdateListener
    implements UpdateListener<ProgressUpdateEvent> {
        private static final String PREFIX = "Digest:";
        private String digest;

        private DigestCaptureUpdateListener() {
        }

        @Override
        public void onUpdate(ProgressUpdateEvent event) {
            String status = event.getStatus();
            if (status != null && status.startsWith(PREFIX)) {
                String digest = status.substring(PREFIX.length()).trim();
                Assert.state((this.digest == null || this.digest.equals(digest) ? 1 : 0) != 0, (String)"Different digests IDs provided");
                this.digest = digest;
            }
        }
    }
}

