/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.boot.buildpack.platform.docker.type.ImageConfig;
import org.springframework.util.Assert;

class StackId {
    private static final String LABEL_NAME = "io.buildpacks.stack.id";
    private final String value;

    StackId(String value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value.equals(((StackId)obj).value);
    }

    boolean hasId() {
        return this.value != null;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }

    static StackId fromImage(Image image) {
        Assert.notNull((Object)image, (String)"Image must not be null");
        return StackId.fromImageConfig(image.getConfig());
    }

    private static StackId fromImageConfig(ImageConfig imageConfig) {
        String value = imageConfig.getLabels().get(LABEL_NAME);
        return new StackId(value);
    }

    static StackId of(String value) {
        Assert.hasText((String)value, (String)"Value must not be empty");
        return new StackId(value);
    }
}

