/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.buildpack.platform.docker.type.Binding;
import org.springframework.boot.buildpack.platform.docker.type.ContainerConfig;
import org.springframework.util.StringUtils;

class Phase {
    private final String name;
    private final boolean verboseLogging;
    private boolean daemonAccess;
    private final List<String> args = new ArrayList<String>();
    private final List<Binding> bindings = new ArrayList<Binding>();
    private final Map<String, String> env = new LinkedHashMap<String, String>();
    private final List<String> securityOptions = new ArrayList<String>();
    private String networkMode;

    Phase(String name, boolean verboseLogging) {
        this.name = name;
        this.verboseLogging = verboseLogging;
    }

    void withDaemonAccess() {
        this.daemonAccess = true;
    }

    void withLogLevelArg() {
        if (this.verboseLogging) {
            this.args.add("-log-level");
            this.args.add("debug");
        }
    }

    void withArgs(Object ... args) {
        Arrays.stream(args).map(Object::toString).forEach(this.args::add);
    }

    void withBinding(Binding binding) {
        this.bindings.add(binding);
    }

    void withEnv(String name, String value) {
        this.env.put(name, value);
    }

    void withNetworkMode(String networkMode) {
        this.networkMode = networkMode;
    }

    void withSecurityOption(String option) {
        this.securityOptions.add(option);
    }

    String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    void apply(ContainerConfig.Update update) {
        if (this.daemonAccess) {
            update.withUser("root");
        }
        update.withCommand("/cnb/lifecycle/" + this.name, StringUtils.toStringArray(this.args));
        update.withLabel("author", "spring-boot");
        this.bindings.forEach(update::withBinding);
        this.env.forEach(update::withEnv);
        if (this.networkMode != null) {
            update.withNetworkMode(this.networkMode);
        }
        this.securityOptions.forEach(update::withSecurityOption);
    }
}

