/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.boot.buildpack.platform.build.BuildLog;
import org.springframework.boot.buildpack.platform.build.BuildOwner;
import org.springframework.boot.buildpack.platform.build.BuildRequest;
import org.springframework.boot.buildpack.platform.build.BuilderMetadata;
import org.springframework.boot.buildpack.platform.build.BuildpackLayersMetadata;
import org.springframework.boot.buildpack.platform.build.BuildpackMetadata;
import org.springframework.boot.buildpack.platform.build.BuildpackResolverContext;
import org.springframework.boot.buildpack.platform.build.BuildpackResolvers;
import org.springframework.boot.buildpack.platform.build.Buildpacks;
import org.springframework.boot.buildpack.platform.build.EphemeralBuilder;
import org.springframework.boot.buildpack.platform.build.ImageType;
import org.springframework.boot.buildpack.platform.build.Lifecycle;
import org.springframework.boot.buildpack.platform.build.PullPolicy;
import org.springframework.boot.buildpack.platform.build.StackId;
import org.springframework.boot.buildpack.platform.docker.DockerApi;
import org.springframework.boot.buildpack.platform.docker.TotalProgressEvent;
import org.springframework.boot.buildpack.platform.docker.TotalProgressPullListener;
import org.springframework.boot.buildpack.platform.docker.TotalProgressPushListener;
import org.springframework.boot.buildpack.platform.docker.UpdateListener;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerConfiguration;
import org.springframework.boot.buildpack.platform.docker.configuration.ResolvedDockerHost;
import org.springframework.boot.buildpack.platform.docker.transport.DockerEngineException;
import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.boot.buildpack.platform.docker.type.ImageArchive;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.io.IOBiConsumer;
import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Builder {
    private final BuildLog log;
    private final DockerApi docker;
    private final DockerConfiguration dockerConfiguration;

    public Builder() {
        this(BuildLog.toSystemOut());
    }

    public Builder(DockerConfiguration dockerConfiguration) {
        this(BuildLog.toSystemOut(), dockerConfiguration);
    }

    public Builder(BuildLog log) {
        this(log, new DockerApi(), null);
    }

    public Builder(BuildLog log, DockerConfiguration dockerConfiguration) {
        this(log, new DockerApi(dockerConfiguration != null ? dockerConfiguration.getHost() : null), dockerConfiguration);
    }

    Builder(BuildLog log, DockerApi docker, DockerConfiguration dockerConfiguration) {
        Assert.notNull((Object)log, (String)"Log must not be null");
        this.log = log;
        this.docker = docker;
        this.dockerConfiguration = dockerConfiguration;
    }

    public void build(BuildRequest request) throws DockerEngineException, IOException {
        Assert.notNull((Object)request, (String)"Request must not be null");
        this.log.start(request);
        String domain = request.getBuilder().getDomain();
        PullPolicy pullPolicy = request.getPullPolicy();
        ImageFetcher imageFetcher = new ImageFetcher(domain, this.getBuilderAuthHeader(), pullPolicy);
        Image builderImage = imageFetcher.fetchImage(ImageType.BUILDER, request.getBuilder());
        BuilderMetadata builderMetadata = BuilderMetadata.fromImage(builderImage);
        request = this.withRunImageIfNeeded(request, builderMetadata);
        Image runImage = imageFetcher.fetchImage(ImageType.RUNNER, request.getRunImage());
        this.assertStackIdsMatch(runImage, builderImage);
        BuildOwner buildOwner = BuildOwner.fromEnv(builderImage.getConfig().getEnv());
        BuildpackLayersMetadata buildpackLayersMetadata = BuildpackLayersMetadata.fromImage(builderImage);
        Buildpacks buildpacks = this.getBuildpacks(request, imageFetcher, builderMetadata, buildpackLayersMetadata);
        EphemeralBuilder ephemeralBuilder = new EphemeralBuilder(buildOwner, builderImage, request.getName(), builderMetadata, request.getCreator(), request.getEnv(), buildpacks);
        this.executeLifecycle(request, ephemeralBuilder);
        this.tagImage(request.getName(), request.getTags());
        if (request.isPublish()) {
            this.pushImages(request.getName(), request.getTags());
        }
    }

    private BuildRequest withRunImageIfNeeded(BuildRequest request, BuilderMetadata metadata) {
        if (request.getRunImage() != null) {
            return request;
        }
        return request.withRunImage(this.getRunImageReference(metadata));
    }

    private ImageReference getRunImageReference(BuilderMetadata metadata) {
        if (metadata.getRunImages() != null && !metadata.getRunImages().isEmpty()) {
            String runImageName = metadata.getRunImages().get(0).getImage();
            return ImageReference.of(runImageName).inTaggedOrDigestForm();
        }
        String runImageName = metadata.getStack().getRunImage().getImage();
        Assert.state((boolean)StringUtils.hasText((String)runImageName), (String)"Run image must be specified in the builder image metadata");
        return ImageReference.of(runImageName).inTaggedOrDigestForm();
    }

    private void assertStackIdsMatch(Image runImage, Image builderImage) {
        StackId runImageStackId = StackId.fromImage(runImage);
        StackId builderImageStackId = StackId.fromImage(builderImage);
        if (runImageStackId.hasId() && builderImageStackId.hasId()) {
            Assert.state((boolean)runImageStackId.equals(builderImageStackId), () -> "Run image stack '" + String.valueOf(runImageStackId) + "' does not match builder stack '" + String.valueOf(builderImageStackId) + "'");
        }
    }

    private Buildpacks getBuildpacks(BuildRequest request, ImageFetcher imageFetcher, BuilderMetadata builderMetadata, BuildpackLayersMetadata buildpackLayersMetadata) {
        BuilderResolverContext resolverContext = new BuilderResolverContext(imageFetcher, builderMetadata, buildpackLayersMetadata);
        return BuildpackResolvers.resolveAll(resolverContext, request.getBuildpacks());
    }

    private void executeLifecycle(BuildRequest request, EphemeralBuilder builder) throws IOException {
        try (Lifecycle lifecycle = new Lifecycle(this.log, this.docker, this.getDockerHost(), request, builder);){
            this.executeLifecycle(builder, lifecycle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeLifecycle(EphemeralBuilder builder, Lifecycle lifecycle) throws IOException {
        ImageArchive archive = builder.getArchive(lifecycle.getApplicationDirectory());
        this.docker.image().load(archive, UpdateListener.none());
        try {
            lifecycle.execute();
        }
        finally {
            this.docker.image().remove(builder.getName(), true);
        }
    }

    private ResolvedDockerHost getDockerHost() {
        boolean bindHostToBuilder = this.dockerConfiguration != null && this.dockerConfiguration.isBindHostToBuilder();
        return bindHostToBuilder ? ResolvedDockerHost.from(this.dockerConfiguration.getHost()) : null;
    }

    private void tagImage(ImageReference sourceReference, List<ImageReference> tags) throws IOException {
        for (ImageReference tag : tags) {
            this.docker.image().tag(sourceReference, tag);
            this.log.taggedImage(tag);
        }
    }

    private void pushImages(ImageReference name, List<ImageReference> tags) throws IOException {
        this.pushImage(name);
        for (ImageReference tag : tags) {
            this.pushImage(tag);
        }
    }

    private void pushImage(ImageReference reference) throws IOException {
        Consumer<TotalProgressEvent> progressConsumer = this.log.pushingImage(reference);
        TotalProgressPushListener listener = new TotalProgressPushListener(progressConsumer);
        this.docker.image().push(reference, listener, this.getPublishAuthHeader());
        this.log.pushedImage(reference);
    }

    private String getBuilderAuthHeader() {
        return this.dockerConfiguration != null && this.dockerConfiguration.getBuilderRegistryAuthentication() != null ? this.dockerConfiguration.getBuilderRegistryAuthentication().getAuthHeader() : null;
    }

    private String getPublishAuthHeader() {
        return this.dockerConfiguration != null && this.dockerConfiguration.getPublishRegistryAuthentication() != null ? this.dockerConfiguration.getPublishRegistryAuthentication().getAuthHeader() : null;
    }

    private class ImageFetcher {
        private final String domain;
        private final String authHeader;
        private final PullPolicy pullPolicy;

        ImageFetcher(String domain, String authHeader, PullPolicy pullPolicy) {
            this.domain = domain;
            this.authHeader = authHeader;
            this.pullPolicy = pullPolicy;
        }

        Image fetchImage(ImageType type, ImageReference reference) throws IOException {
            Assert.notNull((Object)((Object)type), (String)"Type must not be null");
            Assert.notNull((Object)reference, (String)"Reference must not be null");
            Assert.state((this.authHeader == null || reference.getDomain().equals(this.domain) ? 1 : 0) != 0, () -> String.format("%s '%s' must be pulled from the '%s' authenticated registry", StringUtils.capitalize((String)type.getDescription()), reference, this.domain));
            if (this.pullPolicy == PullPolicy.ALWAYS) {
                return this.pullImage(reference, type);
            }
            try {
                return Builder.this.docker.image().inspect(reference);
            }
            catch (DockerEngineException ex) {
                if (this.pullPolicy == PullPolicy.IF_NOT_PRESENT && ex.getStatusCode() == 404) {
                    return this.pullImage(reference, type);
                }
                throw ex;
            }
        }

        private Image pullImage(ImageReference reference, ImageType imageType) throws IOException {
            TotalProgressPullListener listener = new TotalProgressPullListener(Builder.this.log.pullingImage(reference, imageType));
            Image image = Builder.this.docker.image().pull(reference, listener, this.authHeader);
            Builder.this.log.pulledImage(image, imageType);
            return image;
        }
    }

    private class BuilderResolverContext
    implements BuildpackResolverContext {
        private final ImageFetcher imageFetcher;
        private final BuilderMetadata builderMetadata;
        private final BuildpackLayersMetadata buildpackLayersMetadata;

        BuilderResolverContext(ImageFetcher imageFetcher, BuilderMetadata builderMetadata, BuildpackLayersMetadata buildpackLayersMetadata) {
            this.imageFetcher = imageFetcher;
            this.builderMetadata = builderMetadata;
            this.buildpackLayersMetadata = buildpackLayersMetadata;
        }

        @Override
        public List<BuildpackMetadata> getBuildpackMetadata() {
            return this.builderMetadata.getBuildpacks();
        }

        @Override
        public BuildpackLayersMetadata getBuildpackLayersMetadata() {
            return this.buildpackLayersMetadata;
        }

        @Override
        public Image fetchImage(ImageReference reference, ImageType imageType) throws IOException {
            return this.imageFetcher.fetchImage(imageType, reference);
        }

        @Override
        public void exportImageLayers(ImageReference reference, IOBiConsumer<String, TarArchive> exports) throws IOException {
            Builder.this.docker.image().exportLayers(reference, exports);
        }
    }
}

