/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.transport;

import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerHost;
import org.springframework.boot.buildpack.platform.docker.configuration.ResolvedDockerHost;
import org.springframework.boot.buildpack.platform.docker.ssl.SslContextFactory;
import org.springframework.boot.buildpack.platform.docker.transport.HttpClientTransport;
import org.springframework.util.Assert;

final class RemoteHttpClientTransport
extends HttpClientTransport {
    private RemoteHttpClientTransport(CloseableHttpClient client, HttpHost host) {
        super(client, host);
    }

    static RemoteHttpClientTransport createIfPossible(ResolvedDockerHost dockerHost) {
        return RemoteHttpClientTransport.createIfPossible(dockerHost, new SslContextFactory());
    }

    static RemoteHttpClientTransport createIfPossible(ResolvedDockerHost dockerHost, SslContextFactory sslContextFactory) {
        if (!dockerHost.isRemote()) {
            return null;
        }
        return RemoteHttpClientTransport.create(dockerHost, sslContextFactory, HttpHost.create((String)dockerHost.getAddress()));
    }

    private static RemoteHttpClientTransport create(DockerHost host, SslContextFactory sslContextFactory, HttpHost tcpHost) {
        HttpClientBuilder builder = HttpClients.custom();
        if (host.isSecure()) {
            builder.setSSLSocketFactory(RemoteHttpClientTransport.getSecureConnectionSocketFactory(host, sslContextFactory));
        }
        String scheme = host.isSecure() ? "https" : "http";
        HttpHost httpHost = new HttpHost(tcpHost.getHostName(), tcpHost.getPort(), scheme);
        return new RemoteHttpClientTransport(builder.build(), httpHost);
    }

    private static LayeredConnectionSocketFactory getSecureConnectionSocketFactory(DockerHost host, SslContextFactory sslContextFactory) {
        String directory = host.getCertificatePath();
        Assert.hasText((String)directory, () -> "Docker host TLS verification requires trust material location to be specified with certificate path");
        SSLContext sslContext = sslContextFactory.forDirectory(directory);
        return new SSLConnectionSocketFactory(sslContext);
    }
}

