/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import org.springframework.util.Assert;

public final class FilePermissions {
    private FilePermissions() {
    }

    public static int umaskForPath(Path path) throws IOException {
        Assert.notNull((Object)path, (String)"Path must not be null");
        PosixFileAttributeView attributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        Assert.state((attributeView != null ? 1 : 0) != 0, (String)"Unsupported file type for retrieving Posix attributes");
        return FilePermissions.posixPermissionsToUmask(attributeView.readAttributes().permissions());
    }

    public static int posixPermissionsToUmask(Collection<PosixFilePermission> permissions) {
        Assert.notNull(permissions, (String)"Permissions must not be null");
        int owner = FilePermissions.permissionToUmask(permissions, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_READ);
        int group = FilePermissions.permissionToUmask(permissions, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_READ);
        int other = FilePermissions.permissionToUmask(permissions, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_READ);
        return Integer.parseInt("" + owner + group + other, 8);
    }

    private static int permissionToUmask(Collection<PosixFilePermission> permissions, PosixFilePermission execute, PosixFilePermission write, PosixFilePermission read) {
        int value = 0;
        if (permissions.contains((Object)execute)) {
            ++value;
        }
        if (permissions.contains((Object)write)) {
            value += 2;
        }
        if (permissions.contains((Object)read)) {
            value += 4;
        }
        return value;
    }
}

