/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFileAttributeView;
import org.springframework.boot.buildpack.platform.build.Buildpack;
import org.springframework.boot.buildpack.platform.build.BuildpackCoordinates;
import org.springframework.boot.buildpack.platform.build.BuildpackReference;
import org.springframework.boot.buildpack.platform.build.BuildpackResolverContext;
import org.springframework.boot.buildpack.platform.docker.type.Layer;
import org.springframework.boot.buildpack.platform.io.Content;
import org.springframework.boot.buildpack.platform.io.FilePermissions;
import org.springframework.boot.buildpack.platform.io.IOConsumer;
import org.springframework.boot.buildpack.platform.io.Layout;
import org.springframework.boot.buildpack.platform.io.Owner;
import org.springframework.util.Assert;

final class DirectoryBuildpack
implements Buildpack {
    private final Path path;
    private final BuildpackCoordinates coordinates;

    private DirectoryBuildpack(Path path) {
        this.path = path;
        this.coordinates = this.findBuildpackCoordinates(path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BuildpackCoordinates findBuildpackCoordinates(Path path) {
        Path buildpackToml = path.resolve("buildpack.toml");
        Assert.isTrue((boolean)Files.exists(buildpackToml, new LinkOption[0]), () -> "Buildpack descriptor 'buildpack.toml' is required in buildpack '" + path + "'");
        try (InputStream inputStream = Files.newInputStream(buildpackToml, new OpenOption[0]);){
            BuildpackCoordinates buildpackCoordinates = BuildpackCoordinates.fromToml(inputStream, path);
            return buildpackCoordinates;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Error parsing descriptor for buildpack '" + path + "'", ex);
        }
    }

    @Override
    public BuildpackCoordinates getCoordinates() {
        return this.coordinates;
    }

    @Override
    public void apply(IOConsumer<Layer> layers) throws IOException {
        layers.accept(Layer.of(this::addLayerContent));
    }

    private void addLayerContent(Layout layout) throws IOException {
        String id = this.coordinates.getSanitizedId();
        Path cnbPath = Paths.get("/cnb/buildpacks/", id, this.coordinates.getVersion());
        Files.walkFileTree(this.path, new LayoutFileVisitor(this.path, cnbPath, layout));
    }

    static Buildpack resolve(BuildpackResolverContext context, BuildpackReference reference) {
        Path path = reference.asPath();
        if (path != null && Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
            return new DirectoryBuildpack(path);
        }
        return null;
    }

    private static class LayoutFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path basePath;
        private final Path layerPath;
        private final Layout layout;

        LayoutFileVisitor(Path basePath, Path layerPath, Layout layout) {
            this.basePath = basePath;
            this.layerPath = layerPath;
            this.layout = layout;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            PosixFileAttributeView attributeView = Files.getFileAttributeView(file, PosixFileAttributeView.class, new LinkOption[0]);
            Assert.state((attributeView != null ? 1 : 0) != 0, (String)"Buildpack content in a directory is not supported on this operating system");
            int mode = FilePermissions.posixPermissionsToUmask(attributeView.readAttributes().permissions());
            this.layout.file(this.relocate(file), Owner.ROOT, mode, Content.of(file.toFile()));
            return FileVisitResult.CONTINUE;
        }

        private String relocate(Path path) {
            Path node = path.subpath(this.basePath.getNameCount(), path.getNameCount());
            return Paths.get(this.layerPath.toString(), node.toString()).toString();
        }
    }
}

