/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.boot.buildpack.platform.build.BuildpackReference;
import org.springframework.boot.buildpack.platform.build.Creator;
import org.springframework.boot.buildpack.platform.build.PullPolicy;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.io.Owner;
import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.util.Assert;

public class BuildRequest {
    static final String DEFAULT_BUILDER_IMAGE_NAME = "paketobuildpacks/builder:base";
    private static final ImageReference DEFAULT_BUILDER = ImageReference.of("paketobuildpacks/builder:base");
    private final ImageReference name;
    private final Function<Owner, TarArchive> applicationContent;
    private final ImageReference builder;
    private final ImageReference runImage;
    private final Creator creator;
    private final Map<String, String> env;
    private final boolean cleanCache;
    private final boolean verboseLogging;
    private final PullPolicy pullPolicy;
    private final boolean publish;
    private final List<BuildpackReference> buildpacks;

    BuildRequest(ImageReference name, Function<Owner, TarArchive> applicationContent) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Assert.notNull(applicationContent, (String)"ApplicationContent must not be null");
        this.name = name.inTaggedForm();
        this.applicationContent = applicationContent;
        this.builder = DEFAULT_BUILDER;
        this.runImage = null;
        this.env = Collections.emptyMap();
        this.cleanCache = false;
        this.verboseLogging = false;
        this.pullPolicy = PullPolicy.ALWAYS;
        this.publish = false;
        this.creator = Creator.withVersion("");
        this.buildpacks = Collections.emptyList();
    }

    BuildRequest(ImageReference name, Function<Owner, TarArchive> applicationContent, ImageReference builder, ImageReference runImage, Creator creator, Map<String, String> env, boolean cleanCache, boolean verboseLogging, PullPolicy pullPolicy, boolean publish, List<BuildpackReference> buildpacks) {
        this.name = name;
        this.applicationContent = applicationContent;
        this.builder = builder;
        this.runImage = runImage;
        this.creator = creator;
        this.env = env;
        this.cleanCache = cleanCache;
        this.verboseLogging = verboseLogging;
        this.pullPolicy = pullPolicy;
        this.publish = publish;
        this.buildpacks = buildpacks;
    }

    public BuildRequest withBuilder(ImageReference builder) {
        Assert.notNull((Object)builder, (String)"Builder must not be null");
        return new BuildRequest(this.name, this.applicationContent, builder.inTaggedOrDigestForm(), this.runImage, this.creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks);
    }

    public BuildRequest withRunImage(ImageReference runImageName) {
        return new BuildRequest(this.name, this.applicationContent, this.builder, runImageName.inTaggedOrDigestForm(), this.creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks);
    }

    public BuildRequest withCreator(Creator creator) {
        Assert.notNull((Object)creator, (String)"Creator must not be null");
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.runImage, creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks);
    }

    public BuildRequest withEnv(String name, String value) {
        Assert.hasText((String)name, (String)"Name must not be empty");
        Assert.hasText((String)value, (String)"Value must not be empty");
        LinkedHashMap<String, String> env = new LinkedHashMap<String, String>(this.env);
        env.put(name, value);
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.runImage, this.creator, Collections.unmodifiableMap(env), this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks);
    }

    public BuildRequest withEnv(Map<String, String> env) {
        Assert.notNull(env, (String)"Env must not be null");
        LinkedHashMap<String, String> updatedEnv = new LinkedHashMap<String, String>(this.env);
        updatedEnv.putAll(env);
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.runImage, this.creator, Collections.unmodifiableMap(updatedEnv), this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks);
    }

    public BuildRequest withCleanCache(boolean cleanCache) {
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.runImage, this.creator, this.env, cleanCache, this.verboseLogging, this.pullPolicy, this.publish, this.buildpacks);
    }

    public BuildRequest withVerboseLogging(boolean verboseLogging) {
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.runImage, this.creator, this.env, this.cleanCache, verboseLogging, this.pullPolicy, this.publish, this.buildpacks);
    }

    public BuildRequest withPullPolicy(PullPolicy pullPolicy) {
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.runImage, this.creator, this.env, this.cleanCache, this.verboseLogging, pullPolicy, this.publish, this.buildpacks);
    }

    public BuildRequest withPublish(boolean publish) {
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.runImage, this.creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, publish, this.buildpacks);
    }

    public BuildRequest withBuildpacks(BuildpackReference ... buildpacks) {
        Assert.notEmpty((Object[])buildpacks, (String)"Buildpacks must not be empty");
        return this.withBuildpacks(Arrays.asList(buildpacks));
    }

    public BuildRequest withBuildpacks(List<BuildpackReference> buildpacks) {
        Assert.notNull(buildpacks, (String)"Buildpacks must not be null");
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.runImage, this.creator, this.env, this.cleanCache, this.verboseLogging, this.pullPolicy, this.publish, buildpacks);
    }

    public ImageReference getName() {
        return this.name;
    }

    public TarArchive getApplicationContent(Owner owner) {
        return this.applicationContent.apply(owner);
    }

    public ImageReference getBuilder() {
        return this.builder;
    }

    public ImageReference getRunImage() {
        return this.runImage;
    }

    public Creator getCreator() {
        return this.creator;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public boolean isCleanCache() {
        return this.cleanCache;
    }

    public boolean isVerboseLogging() {
        return this.verboseLogging;
    }

    public boolean isPublish() {
        return this.publish;
    }

    public PullPolicy getPullPolicy() {
        return this.pullPolicy;
    }

    public List<BuildpackReference> getBuildpacks() {
        return this.buildpacks;
    }

    public static BuildRequest forJarFile(File jarFile) {
        BuildRequest.assertJarFile(jarFile);
        return BuildRequest.forJarFile(ImageReference.forJarFile(jarFile).inTaggedForm(), jarFile);
    }

    public static BuildRequest forJarFile(ImageReference name, File jarFile) {
        BuildRequest.assertJarFile(jarFile);
        return new BuildRequest(name, owner -> TarArchive.fromZip(jarFile, owner));
    }

    public static BuildRequest of(ImageReference name, Function<Owner, TarArchive> applicationContent) {
        return new BuildRequest(name, applicationContent);
    }

    private static void assertJarFile(File jarFile) {
        Assert.notNull((Object)jarFile, (String)"JarFile must not be null");
        Assert.isTrue((boolean)jarFile.exists(), (String)"JarFile must exist");
        Assert.isTrue((boolean)jarFile.isFile(), (String)"JarFile must be a file");
    }
}

