/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.io.IOException;
import java.util.Map;
import org.springframework.boot.buildpack.platform.build.BuildOwner;
import org.springframework.boot.buildpack.platform.build.BuilderMetadata;
import org.springframework.boot.buildpack.platform.build.Creator;
import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.boot.buildpack.platform.docker.type.ImageArchive;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.docker.type.Layer;
import org.springframework.boot.buildpack.platform.io.Content;
import org.springframework.boot.buildpack.platform.io.Owner;

class EphemeralBuilder {
    static final String BUILDER_FOR_LABEL_NAME = "org.springframework.boot.builderFor";
    private final BuildOwner buildOwner;
    private final BuilderMetadata builderMetadata;
    private final ImageArchive archive;
    private final Creator creator;

    EphemeralBuilder(BuildOwner buildOwner, Image builderImage, ImageReference targetImage, BuilderMetadata builderMetadata, Creator creator, Map<String, String> env) throws IOException {
        ImageReference name = ImageReference.random("pack.local/builder/").inTaggedForm();
        this.buildOwner = buildOwner;
        this.creator = creator;
        this.builderMetadata = builderMetadata.copy(this::updateMetadata);
        this.archive = ImageArchive.from(builderImage, update -> {
            update.withUpdatedConfig(this.builderMetadata::attachTo);
            update.withUpdatedConfig(config -> config.withLabel(BUILDER_FOR_LABEL_NAME, targetImage.toString()));
            update.withTag(name);
            if (env != null && !env.isEmpty()) {
                update.withNewLayer(this.getEnvLayer(env));
            }
        });
    }

    private void updateMetadata(BuilderMetadata.Update update) {
        update.withCreatedBy(this.creator.getName(), this.creator.getVersion());
    }

    private Layer getEnvLayer(Map<String, String> env) throws IOException {
        return Layer.of(layout -> {
            for (Map.Entry entry : env.entrySet()) {
                String name = "/platform/env/" + (String)entry.getKey();
                Content content = Content.of(entry.getValue() != null ? (String)entry.getValue() : "");
                layout.file(name, Owner.ROOT, content);
            }
        });
    }

    ImageReference getName() {
        return this.archive.getTag();
    }

    Owner getBuildOwner() {
        return this.buildOwner;
    }

    BuilderMetadata getBuilderMetadata() {
        return this.builderMetadata;
    }

    ImageArchive getArchive() {
        return this.archive;
    }

    public String toString() {
        return this.archive.getTag().toString();
    }
}

