/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.transport;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerConfiguration;
import org.springframework.boot.buildpack.platform.docker.transport.LocalHttpClientTransport;
import org.springframework.boot.buildpack.platform.docker.transport.RemoteHttpClientTransport;
import org.springframework.boot.buildpack.platform.io.IOConsumer;
import org.springframework.boot.buildpack.platform.system.Environment;

public interface HttpTransport {
    public Response get(URI var1) throws IOException;

    public Response post(URI var1) throws IOException;

    public Response post(URI var1, String var2, IOConsumer<OutputStream> var3) throws IOException;

    public Response put(URI var1, String var2, IOConsumer<OutputStream> var3) throws IOException;

    public Response delete(URI var1) throws IOException;

    public static HttpTransport create() {
        return HttpTransport.create(DockerConfiguration.withDefaults());
    }

    public static HttpTransport create(DockerConfiguration dockerConfiguration) {
        return HttpTransport.create(Environment.SYSTEM, dockerConfiguration);
    }

    public static HttpTransport create(Environment environment) {
        return HttpTransport.create(environment, DockerConfiguration.withDefaults());
    }

    public static HttpTransport create(Environment environment, DockerConfiguration dockerConfiguration) {
        RemoteHttpClientTransport remote = RemoteHttpClientTransport.createIfPossible(environment, dockerConfiguration);
        return remote != null ? remote : LocalHttpClientTransport.create(environment, dockerConfiguration);
    }

    public static interface Response
    extends Closeable {
        public InputStream getContent() throws IOException;
    }
}

