/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.configuration;

import org.springframework.boot.buildpack.platform.docker.configuration.DockerRegistryAuthentication;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerRegistryTokenAuthentication;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerRegistryUserAuthentication;
import org.springframework.util.Assert;

public final class DockerConfiguration {
    private final DockerRegistryAuthentication authentication;

    private DockerConfiguration(DockerRegistryAuthentication authentication) {
        this.authentication = authentication;
    }

    public DockerRegistryAuthentication getRegistryAuthentication() {
        return this.authentication;
    }

    public static DockerConfiguration withDefaults() {
        return new DockerConfiguration(null);
    }

    public static DockerConfiguration withRegistryTokenAuthentication(String token) {
        Assert.notNull((Object)token, (String)"Token must not be null");
        return new DockerConfiguration(new DockerRegistryTokenAuthentication(token));
    }

    public static DockerConfiguration withRegistryUserAuthentication(String username, String password, String url, String email) {
        Assert.notNull((Object)username, (String)"Username must not be null");
        Assert.notNull((Object)password, (String)"Password must not be null");
        return new DockerConfiguration(new DockerRegistryUserAuthentication(username, password, url, email));
    }
}

