/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.transport;

import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.springframework.boot.buildpack.platform.docker.ssl.SslContextFactory;
import org.springframework.boot.buildpack.platform.docker.transport.HttpClientTransport;
import org.springframework.boot.buildpack.platform.system.Environment;
import org.springframework.util.Assert;

final class RemoteHttpClientTransport
extends HttpClientTransport {
    private static final String DOCKER_HOST = "DOCKER_HOST";
    private static final String DOCKER_TLS_VERIFY = "DOCKER_TLS_VERIFY";
    private static final String DOCKER_CERT_PATH = "DOCKER_CERT_PATH";

    private RemoteHttpClientTransport(CloseableHttpClient client, HttpHost host) {
        super(client, host);
    }

    static RemoteHttpClientTransport createIfPossible(Environment environment) {
        return RemoteHttpClientTransport.createIfPossible(environment, new SslContextFactory());
    }

    static RemoteHttpClientTransport createIfPossible(Environment environment, SslContextFactory sslContextFactory) {
        String host = environment.get(DOCKER_HOST);
        return host != null ? RemoteHttpClientTransport.create(environment, sslContextFactory, HttpHost.create((String)host)) : null;
    }

    private static RemoteHttpClientTransport create(Environment environment, SslContextFactory sslContextFactory, HttpHost tcpHost) {
        HttpClientBuilder builder = HttpClients.custom();
        boolean secure = RemoteHttpClientTransport.isSecure(environment);
        if (secure) {
            builder.setSSLSocketFactory(RemoteHttpClientTransport.getSecureConnectionSocketFactory(environment, sslContextFactory));
        }
        String scheme = secure ? "https" : "http";
        HttpHost httpHost = new HttpHost(tcpHost.getHostName(), tcpHost.getPort(), scheme);
        return new RemoteHttpClientTransport(builder.build(), httpHost);
    }

    private static LayeredConnectionSocketFactory getSecureConnectionSocketFactory(Environment environment, SslContextFactory sslContextFactory) {
        String directory = environment.get(DOCKER_CERT_PATH);
        Assert.hasText((String)directory, () -> "DOCKER_TLS_VERIFY requires trust material location to be specified with DOCKER_CERT_PATH");
        SSLContext sslContext = sslContextFactory.forDirectory(directory);
        return new SSLConnectionSocketFactory(sslContext);
    }

    private static boolean isSecure(Environment environment) {
        String secure = environment.get(DOCKER_TLS_VERIFY);
        try {
            return secure != null && Integer.parseInt(secure) == 1;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }
}

