/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.transport;

import java.net.URI;
import org.springframework.boot.buildpack.platform.docker.transport.Errors;
import org.springframework.util.Assert;

public class DockerEngineException
extends RuntimeException {
    private final int statusCode;
    private final String reasonPhrase;
    private final Errors errors;

    DockerEngineException(String host, URI uri, int statusCode, String reasonPhrase, Errors errors) {
        super(DockerEngineException.buildMessage(host, uri, statusCode, reasonPhrase, errors));
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
        this.errors = errors;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public Errors getErrors() {
        return this.errors;
    }

    private static String buildMessage(String host, URI uri, int statusCode, String reasonPhrase, Errors errors) {
        Assert.notNull((Object)host, (String)"host must not be null");
        Assert.notNull((Object)uri, (String)"URI must not be null");
        StringBuilder message = new StringBuilder("Docker API call to '" + host + uri + "' failed with status code " + statusCode);
        if (reasonPhrase != null && !reasonPhrase.isEmpty()) {
            message.append(" \"" + reasonPhrase + "\"");
        }
        if (errors != null && !errors.isEmpty()) {
            message.append(" " + errors);
        }
        return message.toString();
    }
}

