/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.springframework.boot.buildpack.platform.io.Content;
import org.springframework.boot.buildpack.platform.io.Layout;
import org.springframework.boot.buildpack.platform.io.Owner;
import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.util.StreamUtils;

class TarLayoutWriter
implements Layout,
Closeable {
    static final long NORMALIZED_MOD_TIME = TarArchive.NORMALIZED_TIME.toEpochMilli();
    private final TarArchiveOutputStream outputStream;

    TarLayoutWriter(OutputStream outputStream) {
        this.outputStream = new TarArchiveOutputStream(outputStream);
        this.outputStream.setLongFileMode(3);
    }

    @Override
    public void folder(String name, Owner owner) throws IOException {
        this.outputStream.putArchiveEntry((ArchiveEntry)this.createFolderEntry(name, owner));
        this.outputStream.closeArchiveEntry();
    }

    @Override
    public void file(String name, Owner owner, Content content) throws IOException {
        this.outputStream.putArchiveEntry((ArchiveEntry)this.createFileEntry(name, owner, content.size()));
        content.writeTo(StreamUtils.nonClosing((OutputStream)this.outputStream));
        this.outputStream.closeArchiveEntry();
    }

    private TarArchiveEntry createFolderEntry(String name, Owner owner) {
        return this.createEntry(name, owner, (byte)53, 493, 0);
    }

    private TarArchiveEntry createFileEntry(String name, Owner owner, int size) {
        return this.createEntry(name, owner, (byte)48, 420, size);
    }

    private TarArchiveEntry createEntry(String name, Owner owner, byte linkFlag, int mode, int size) {
        TarArchiveEntry entry = new TarArchiveEntry(name, linkFlag, true);
        entry.setUserId(owner.getUid());
        entry.setGroupId(owner.getGid());
        entry.setMode(mode);
        entry.setModTime(NORMALIZED_MOD_TIME);
        entry.setSize((long)size);
        return entry;
    }

    void finish() throws IOException {
        this.outputStream.finish();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

