/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.boot.buildpack.platform.build.Creator;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.io.Owner;
import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.util.Assert;

public class BuildRequest {
    static final String DEFAULT_BUILDER_IMAGE_NAME = "cloudfoundry/cnb:bionic-platform-api-0.2";
    private static final ImageReference DEFAULT_BUILDER = ImageReference.of("cloudfoundry/cnb:bionic-platform-api-0.2");
    private final ImageReference name;
    private final Function<Owner, TarArchive> applicationContent;
    private final ImageReference builder;
    private final Creator creator;
    private final Map<String, String> env;
    private final boolean cleanCache;
    private final boolean verboseLogging;

    BuildRequest(ImageReference name, Function<Owner, TarArchive> applicationContent) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Assert.notNull(applicationContent, (String)"ApplicationContent must not be null");
        this.name = name.inTaggedForm();
        this.applicationContent = applicationContent;
        this.builder = DEFAULT_BUILDER;
        this.env = Collections.emptyMap();
        this.cleanCache = false;
        this.verboseLogging = false;
        this.creator = Creator.withVersion("");
    }

    BuildRequest(ImageReference name, Function<Owner, TarArchive> applicationContent, ImageReference builder, Creator creator, Map<String, String> env, boolean cleanCache, boolean verboseLogging) {
        this.name = name;
        this.applicationContent = applicationContent;
        this.builder = builder;
        this.creator = creator;
        this.env = env;
        this.cleanCache = cleanCache;
        this.verboseLogging = verboseLogging;
    }

    public BuildRequest withBuilder(ImageReference builder) {
        Assert.notNull((Object)builder, (String)"Builder must not be null");
        return new BuildRequest(this.name, this.applicationContent, builder.inTaggedForm(), this.creator, this.env, this.cleanCache, this.verboseLogging);
    }

    public BuildRequest withCreator(Creator creator) {
        Assert.notNull((Object)creator, (String)"Creator must not be null");
        return new BuildRequest(this.name, this.applicationContent, this.builder, creator, this.env, this.cleanCache, this.verboseLogging);
    }

    public BuildRequest withEnv(String name, String value) {
        Assert.hasText((String)name, (String)"Name must not be empty");
        Assert.hasText((String)value, (String)"Value must not be empty");
        LinkedHashMap<String, String> env = new LinkedHashMap<String, String>(this.env);
        env.put(name, value);
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.creator, Collections.unmodifiableMap(env), this.cleanCache, this.verboseLogging);
    }

    public BuildRequest withEnv(Map<String, String> env) {
        Assert.notNull(env, (String)"Env must not be null");
        LinkedHashMap<String, String> updatedEnv = new LinkedHashMap<String, String>(this.env);
        updatedEnv.putAll(env);
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.creator, Collections.unmodifiableMap(updatedEnv), this.cleanCache, this.verboseLogging);
    }

    public BuildRequest withCleanCache(boolean cleanCache) {
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.creator, this.env, cleanCache, this.verboseLogging);
    }

    public BuildRequest withVerboseLogging(boolean verboseLogging) {
        return new BuildRequest(this.name, this.applicationContent, this.builder, this.creator, this.env, this.cleanCache, verboseLogging);
    }

    public ImageReference getName() {
        return this.name;
    }

    public TarArchive getApplicationContent(Owner owner) {
        return this.applicationContent.apply(owner);
    }

    public ImageReference getBuilder() {
        return this.builder;
    }

    public Creator getCreator() {
        return this.creator;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public boolean isCleanCache() {
        return this.cleanCache;
    }

    public boolean isVerboseLogging() {
        return this.verboseLogging;
    }

    public static BuildRequest forJarFile(File jarFile) {
        BuildRequest.assertJarFile(jarFile);
        return BuildRequest.forJarFile(ImageReference.forJarFile(jarFile).inTaggedForm(), jarFile);
    }

    public static BuildRequest forJarFile(ImageReference name, File jarFile) {
        BuildRequest.assertJarFile(jarFile);
        return new BuildRequest(name, owner -> TarArchive.fromZip(jarFile, owner));
    }

    public static BuildRequest of(ImageReference name, Function<Owner, TarArchive> applicationContent) {
        return new BuildRequest(name, applicationContent);
    }

    private static void assertJarFile(File jarFile) {
        Assert.notNull((Object)jarFile, (String)"JarFile must not be null");
        Assert.isTrue((boolean)jarFile.exists(), (String)"JarFile must exist");
        Assert.isTrue((boolean)jarFile.isFile(), (String)"JarFile must be a file");
    }
}

