/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.buildpack.platform.build.ApiVersion;
import org.springframework.util.StringUtils;

final class ApiVersions {
    static final ApiVersions SUPPORTED_PLATFORMS = new ApiVersions(ApiVersion.of(0, 2), ApiVersion.of(0, 3));
    private final ApiVersion[] apiVersions;

    private ApiVersions(ApiVersion ... versions) {
        this.apiVersions = versions;
    }

    void assertSupports(ApiVersion other) {
        for (ApiVersion apiVersion : this.apiVersions) {
            if (!apiVersion.supports(other)) continue;
            return;
        }
        throw new IllegalStateException("Detected platform API version '" + other + "' is not included in supported versions '" + this + "'");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ApiVersions other = (ApiVersions)obj;
        return Arrays.equals(this.apiVersions, other.apiVersions);
    }

    public int hashCode() {
        return Arrays.hashCode(this.apiVersions);
    }

    public String toString() {
        return StringUtils.arrayToCommaDelimitedString((Object[])this.apiVersions);
    }

    static ApiVersions parse(String ... values) {
        List<ApiVersion> versions = Arrays.stream(values).map(ApiVersion::parse).collect(Collectors.toList());
        return new ApiVersions(versions.toArray(new ApiVersion[0]));
    }
}

