/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.batch.jdbc.autoconfigure;

import java.util.List;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.support.DefaultBatchConfiguration;
import org.springframework.batch.core.configuration.support.JdbcDefaultBatchConfiguration;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.batch.autoconfigure.BatchAutoConfiguration;
import org.springframework.boot.batch.autoconfigure.BatchConversionServiceCustomizer;
import org.springframework.boot.batch.autoconfigure.BatchJobLauncherAutoConfiguration;
import org.springframework.boot.batch.autoconfigure.BatchTaskExecutor;
import org.springframework.boot.batch.autoconfigure.BatchTransactionManager;
import org.springframework.boot.batch.jdbc.autoconfigure.BatchDataSource;
import org.springframework.boot.batch.jdbc.autoconfigure.BatchDataSourceScriptDatabaseInitializer;
import org.springframework.boot.batch.jdbc.autoconfigure.BatchJdbcProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.autoconfigure.DataSourceAutoConfiguration;
import org.springframework.boot.sql.autoconfigure.init.OnDatabaseInitializationCondition;
import org.springframework.boot.sql.init.dependency.DatabaseInitializationDependencyConfigurer;
import org.springframework.boot.transaction.autoconfigure.TransactionAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Isolation;

@AutoConfiguration(before={BatchAutoConfiguration.class, BatchJobLauncherAutoConfiguration.class}, after={DataSourceAutoConfiguration.class, TransactionAutoConfiguration.class}, afterName={"org.springframework.boot.hibernate.autoconfigure.HibernateJpaAutoConfiguration"})
@ConditionalOnClass(value={JobOperator.class, DataSource.class, DatabasePopulator.class})
@ConditionalOnBean(value={DataSource.class, PlatformTransactionManager.class})
@ConditionalOnMissingBean(value={DefaultBatchConfiguration.class}, annotation={EnableBatchProcessing.class})
@EnableConfigurationProperties(value={BatchJdbcProperties.class})
@Import(value={DatabaseInitializationDependencyConfigurer.class})
public final class BatchJdbcAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    static class SpringBootBatchJdbcConfiguration
    extends JdbcDefaultBatchConfiguration {
        private final DataSource dataSource;
        private final PlatformTransactionManager transactionManager;
        private final @Nullable TaskExecutor taskExecutor;
        private final BatchJdbcProperties properties;
        private final List<BatchConversionServiceCustomizer> batchConversionServiceCustomizers;
        private final @Nullable ExecutionContextSerializer executionContextSerializer;
        private final @Nullable JobParametersConverter jobParametersConverter;

        SpringBootBatchJdbcConfiguration(DataSource dataSource, @BatchDataSource ObjectProvider<DataSource> batchDataSource, PlatformTransactionManager transactionManager, @BatchTransactionManager ObjectProvider<PlatformTransactionManager> batchTransactionManager, @BatchTaskExecutor ObjectProvider<TaskExecutor> batchTaskExecutor, BatchJdbcProperties properties, ObjectProvider<BatchConversionServiceCustomizer> batchConversionServiceCustomizers, ObjectProvider<ExecutionContextSerializer> executionContextSerializer, ObjectProvider<JobParametersConverter> jobParametersConverter) {
            this.dataSource = (DataSource)batchDataSource.getIfAvailable(() -> dataSource);
            this.transactionManager = (PlatformTransactionManager)batchTransactionManager.getIfAvailable(() -> transactionManager);
            this.taskExecutor = (TaskExecutor)batchTaskExecutor.getIfAvailable();
            this.properties = properties;
            this.batchConversionServiceCustomizers = batchConversionServiceCustomizers.orderedStream().toList();
            this.executionContextSerializer = (ExecutionContextSerializer)executionContextSerializer.getIfAvailable();
            this.jobParametersConverter = (JobParametersConverter)jobParametersConverter.getIfAvailable();
        }

        protected DataSource getDataSource() {
            return this.dataSource;
        }

        protected PlatformTransactionManager getTransactionManager() {
            return this.transactionManager;
        }

        protected String getTablePrefix() {
            String tablePrefix = this.properties.getTablePrefix();
            return tablePrefix != null ? tablePrefix : super.getTablePrefix();
        }

        protected boolean getValidateTransactionState() {
            return this.properties.isValidateTransactionState();
        }

        protected Isolation getIsolationLevelForCreate() {
            Isolation isolation = this.properties.getIsolationLevelForCreate();
            return isolation != null ? isolation : super.getIsolationLevelForCreate();
        }

        protected ConfigurableConversionService getConversionService() {
            ConfigurableConversionService conversionService = super.getConversionService();
            for (BatchConversionServiceCustomizer customizer : this.batchConversionServiceCustomizers) {
                customizer.customize(conversionService);
            }
            return conversionService;
        }

        protected ExecutionContextSerializer getExecutionContextSerializer() {
            return this.executionContextSerializer != null ? this.executionContextSerializer : super.getExecutionContextSerializer();
        }

        @Deprecated(since="4.0.0", forRemoval=true)
        protected JobParametersConverter getJobParametersConverter() {
            return this.jobParametersConverter != null ? this.jobParametersConverter : super.getJobParametersConverter();
        }

        protected TaskExecutor getTaskExecutor() {
            return this.taskExecutor != null ? this.taskExecutor : super.getTaskExecutor();
        }

        static class OnBatchDatasourceInitializationCondition
        extends OnDatabaseInitializationCondition {
            OnBatchDatasourceInitializationCondition() {
                super("Batch", new String[]{"spring.batch.jdbc.initialize-schema"});
            }
        }

        @Configuration(proxyBeanMethods=false)
        @Conditional(value={OnBatchDatasourceInitializationCondition.class})
        static class DataSourceInitializerConfiguration {
            DataSourceInitializerConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean
            BatchDataSourceScriptDatabaseInitializer batchDataSourceInitializer(DataSource dataSource, @BatchDataSource ObjectProvider<DataSource> batchDataSource, BatchJdbcProperties properties) {
                return new BatchDataSourceScriptDatabaseInitializer((DataSource)batchDataSource.getIfAvailable(() -> dataSource), properties);
            }
        }
    }
}

