/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms;

import io.micrometer.observation.ObservationRegistry;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.ExceptionListener;
import java.time.Duration;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.Assert;

public final class DefaultJmsListenerContainerFactoryConfigurer {
    private DestinationResolver destinationResolver;
    private MessageConverter messageConverter;
    private ExceptionListener exceptionListener;
    private JtaTransactionManager transactionManager;
    private JmsProperties jmsProperties;
    private ObservationRegistry observationRegistry;

    void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    void setTransactionManager(JtaTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    void setJmsProperties(JmsProperties jmsProperties) {
        this.jmsProperties = jmsProperties;
    }

    public void setObservationRegistry(ObservationRegistry observationRegistry) {
        this.observationRegistry = observationRegistry;
    }

    public void configure(DefaultJmsListenerContainerFactory factory, ConnectionFactory connectionFactory) {
        Assert.notNull((Object)factory, (String)"'factory' must not be null");
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' must not be null");
        JmsProperties.Listener listenerProperties = this.jmsProperties.getListener();
        JmsProperties.Listener.Session sessionProperties = listenerProperties.getSession();
        factory.setConnectionFactory(connectionFactory);
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(this.jmsProperties::isPubSubDomain).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory).setPubSubDomain(arg_0));
        map.from(this.jmsProperties::isSubscriptionDurable).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory).setSubscriptionDurable(arg_0));
        map.from(this.jmsProperties::getClientId).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory).setClientId(arg_0));
        map.from((Object)this.transactionManager).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory).setTransactionManager(arg_0));
        map.from((Object)this.destinationResolver).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory).setDestinationResolver(arg_0));
        map.from((Object)this.messageConverter).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory).setMessageConverter(arg_0));
        map.from((Object)this.exceptionListener).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory).setExceptionListener(arg_0));
        map.from(sessionProperties.getAcknowledgeMode()::getMode).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory).setSessionAcknowledgeMode(arg_0));
        if (this.transactionManager == null && sessionProperties.getTransacted() == null) {
            factory.setSessionTransacted(Boolean.valueOf(true));
        }
        map.from((Object)this.observationRegistry).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory).setObservationRegistry(arg_0));
        map.from(sessionProperties::getTransacted).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory).setSessionTransacted(arg_0));
        map.from(listenerProperties::isAutoStartup).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory).setAutoStartup(arg_0));
        map.from(listenerProperties::formatConcurrency).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory).setConcurrency(arg_0));
        map.from(listenerProperties::getReceiveTimeout).as(Duration::toMillis).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory).setReceiveTimeout(arg_0));
        map.from(listenerProperties::getMaxMessagesPerTask).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory).setMaxMessagesPerTask(arg_0));
    }
}

