/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.task;

import java.util.concurrent.Executor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.autoconfigure.task.TaskExecutionProperties;
import org.springframework.boot.autoconfigure.thread.Threading;
import org.springframework.boot.task.SimpleAsyncTaskExecutorBuilder;
import org.springframework.boot.task.SimpleAsyncTaskExecutorCustomizer;
import org.springframework.boot.task.ThreadPoolTaskExecutorBuilder;
import org.springframework.boot.task.ThreadPoolTaskExecutorCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

class TaskExecutorConfigurations {
    TaskExecutorConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    static class SimpleAsyncTaskExecutorBuilderConfiguration {
        private final TaskExecutionProperties properties;
        private final ObjectProvider<SimpleAsyncTaskExecutorCustomizer> taskExecutorCustomizers;
        private final ObjectProvider<TaskDecorator> taskDecorator;

        SimpleAsyncTaskExecutorBuilderConfiguration(TaskExecutionProperties properties, ObjectProvider<SimpleAsyncTaskExecutorCustomizer> taskExecutorCustomizers, ObjectProvider<TaskDecorator> taskDecorator) {
            this.properties = properties;
            this.taskExecutorCustomizers = taskExecutorCustomizers;
            this.taskDecorator = taskDecorator;
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnThreading(value=Threading.PLATFORM)
        SimpleAsyncTaskExecutorBuilder simpleAsyncTaskExecutorBuilder() {
            return this.builder();
        }

        @Bean(name={"simpleAsyncTaskExecutorBuilder"})
        @ConditionalOnMissingBean
        @ConditionalOnThreading(value=Threading.VIRTUAL)
        SimpleAsyncTaskExecutorBuilder simpleAsyncTaskExecutorBuilderVirtualThreads() {
            SimpleAsyncTaskExecutorBuilder builder = this.builder();
            builder = builder.virtualThreads(Boolean.valueOf(true));
            return builder;
        }

        private SimpleAsyncTaskExecutorBuilder builder() {
            SimpleAsyncTaskExecutorBuilder builder = new SimpleAsyncTaskExecutorBuilder();
            builder = builder.threadNamePrefix(this.properties.getThreadNamePrefix());
            builder = builder.customizers(this.taskExecutorCustomizers.orderedStream()::iterator);
            builder = builder.taskDecorator((TaskDecorator)this.taskDecorator.getIfUnique());
            TaskExecutionProperties.Simple simple = this.properties.getSimple();
            builder = builder.concurrencyLimit(simple.getConcurrencyLimit());
            TaskExecutionProperties.Shutdown shutdown = this.properties.getShutdown();
            if (shutdown.isAwaitTermination()) {
                builder = builder.taskTerminationTimeout(shutdown.getAwaitTerminationPeriod());
            }
            return builder;
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class ThreadPoolTaskExecutorBuilderConfiguration {
        ThreadPoolTaskExecutorBuilderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ThreadPoolTaskExecutorBuilder.class})
        ThreadPoolTaskExecutorBuilder threadPoolTaskExecutorBuilder(TaskExecutionProperties properties, ObjectProvider<ThreadPoolTaskExecutorCustomizer> threadPoolTaskExecutorCustomizers, ObjectProvider<TaskDecorator> taskDecorator) {
            TaskExecutionProperties.Pool pool = properties.getPool();
            ThreadPoolTaskExecutorBuilder builder = new ThreadPoolTaskExecutorBuilder();
            builder = builder.queueCapacity(pool.getQueueCapacity());
            builder = builder.corePoolSize(pool.getCoreSize());
            builder = builder.maxPoolSize(pool.getMaxSize());
            builder = builder.allowCoreThreadTimeOut(pool.isAllowCoreThreadTimeout());
            builder = builder.keepAlive(pool.getKeepAlive());
            builder = builder.acceptTasksAfterContextClose(pool.getShutdown().isAcceptTasksAfterContextClose());
            TaskExecutionProperties.Shutdown shutdown = properties.getShutdown();
            builder = builder.awaitTermination(shutdown.isAwaitTermination());
            builder = builder.awaitTerminationPeriod(shutdown.getAwaitTerminationPeriod());
            builder = builder.threadNamePrefix(properties.getThreadNamePrefix());
            builder = builder.customizers(threadPoolTaskExecutorCustomizers.orderedStream()::iterator);
            builder = builder.taskDecorator((TaskDecorator)taskDecorator.getIfUnique());
            return builder;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={Executor.class})
    static class TaskExecutorConfiguration {
        TaskExecutorConfiguration() {
        }

        @Bean(name={"applicationTaskExecutor", "taskExecutor"})
        @ConditionalOnThreading(value=Threading.VIRTUAL)
        SimpleAsyncTaskExecutor applicationTaskExecutorVirtualThreads(SimpleAsyncTaskExecutorBuilder builder) {
            return builder.build();
        }

        @Lazy
        @Bean(name={"applicationTaskExecutor", "taskExecutor"})
        @ConditionalOnThreading(value=Threading.PLATFORM)
        ThreadPoolTaskExecutor applicationTaskExecutor(ThreadPoolTaskExecutorBuilder threadPoolTaskExecutorBuilder) {
            return threadPoolTaskExecutorBuilder.build();
        }
    }
}

