/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.server.Cookie;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.ResponseCookie;
import org.springframework.util.StringUtils;
import org.springframework.web.server.session.CookieWebSessionIdResolver;
import org.springframework.web.server.session.WebSessionIdResolver;
import org.springframework.web.server.session.WebSessionManager;
import reactor.core.publisher.Mono;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={WebSessionManager.class, Mono.class})
@EnableConfigurationProperties(value={WebFluxProperties.class, ServerProperties.class})
public class WebSessionIdResolverAutoConfiguration {
    private final ServerProperties serverProperties;

    public WebSessionIdResolverAutoConfiguration(ServerProperties serverProperties, WebFluxProperties webFluxProperties) {
        this.serverProperties = serverProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public WebSessionIdResolver webSessionIdResolver() {
        CookieWebSessionIdResolver resolver = new CookieWebSessionIdResolver();
        String cookieName = this.serverProperties.getReactive().getSession().getCookie().getName();
        if (StringUtils.hasText((String)cookieName)) {
            resolver.setCookieName(cookieName);
        }
        resolver.addCookieInitializer(this::initializeCookie);
        return resolver;
    }

    private void initializeCookie(ResponseCookie.ResponseCookieBuilder builder) {
        Cookie cookie = this.serverProperties.getReactive().getSession().getCookie();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(() -> ((Cookie)cookie).getDomain()).to(arg_0 -> ((ResponseCookie.ResponseCookieBuilder)builder).domain(arg_0));
        map.from(() -> ((Cookie)cookie).getPath()).to(arg_0 -> ((ResponseCookie.ResponseCookieBuilder)builder).path(arg_0));
        map.from(() -> ((Cookie)cookie).getHttpOnly()).to(arg_0 -> ((ResponseCookie.ResponseCookieBuilder)builder).httpOnly(arg_0));
        map.from(() -> ((Cookie)cookie).getSecure()).to(arg_0 -> ((ResponseCookie.ResponseCookieBuilder)builder).secure(arg_0));
        map.from(() -> ((Cookie)cookie).getMaxAge()).to(arg_0 -> ((ResponseCookie.ResponseCookieBuilder)builder).maxAge(arg_0));
        map.from((Object)this.getSameSite(cookie)).to(arg_0 -> ((ResponseCookie.ResponseCookieBuilder)builder).sameSite(arg_0));
    }

    private String getSameSite(Cookie properties) {
        Cookie.SameSite sameSite = properties.getSameSite();
        return sameSite != null ? sameSite.attributeValue() : null;
    }
}

