/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.graphql.reactive;

import graphql.GraphQL;
import java.util.Collections;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.graphql.GraphQlAutoConfiguration;
import org.springframework.boot.autoconfigure.graphql.GraphQlCorsProperties;
import org.springframework.boot.autoconfigure.graphql.GraphQlProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.graphql.GraphQlService;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.web.WebGraphQlHandler;
import org.springframework.graphql.web.WebInterceptor;
import org.springframework.graphql.web.webflux.GraphQlHttpHandler;
import org.springframework.graphql.web.webflux.GraphQlWebSocketHandler;
import org.springframework.graphql.web.webflux.GraphiQlHandler;
import org.springframework.graphql.web.webflux.SchemaHandler;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.config.CorsRegistry;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.socket.server.support.WebSocketUpgradeHandlerPredicate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={GraphQL.class, GraphQlHttpHandler.class})
@ConditionalOnBean(value={GraphQlService.class})
@AutoConfigureAfter(value={GraphQlAutoConfiguration.class})
@EnableConfigurationProperties(value={GraphQlCorsProperties.class})
public class GraphQlWebFluxAutoConfiguration {
    private static final Log logger = LogFactory.getLog(GraphQlWebFluxAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public GraphQlHttpHandler graphQlHttpHandler(WebGraphQlHandler webGraphQlHandler) {
        return new GraphQlHttpHandler(webGraphQlHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    public WebGraphQlHandler webGraphQlHandler(GraphQlService service, ObjectProvider<WebInterceptor> interceptorsProvider) {
        return WebGraphQlHandler.builder((GraphQlService)service).interceptors(interceptorsProvider.orderedStream().collect(Collectors.toList())).build();
    }

    @Bean
    public RouterFunction<ServerResponse> graphQlEndpoint(GraphQlHttpHandler handler, GraphQlSource graphQlSource, GraphQlProperties properties, ResourceLoader resourceLoader) {
        String graphQLPath = properties.getPath();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("GraphQL endpoint HTTP POST " + graphQLPath));
        }
        RouterFunctions.Builder builder = RouterFunctions.route().GET(graphQLPath, request -> ((ServerResponse.BodyBuilder)ServerResponse.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).headers(headers -> headers.setAllow(Collections.singleton(HttpMethod.POST)))).build()).POST(graphQLPath, RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON}).and(RequestPredicates.contentType((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON})), arg_0 -> ((GraphQlHttpHandler)handler).handleRequest(arg_0));
        if (properties.getGraphiql().isEnabled()) {
            GraphiQlHandler graphiQlHandler = new GraphiQlHandler(graphQLPath, properties.getWebsocket().getPath());
            builder = builder.GET(properties.getGraphiql().getPath(), arg_0 -> ((GraphiQlHandler)graphiQlHandler).handleRequest(arg_0));
        }
        if (properties.getSchema().getPrinter().isEnabled()) {
            SchemaHandler schemaHandler = new SchemaHandler(graphQlSource);
            builder = builder.GET(graphQLPath + "/schema", arg_0 -> ((SchemaHandler)schemaHandler).handleRequest(arg_0));
        }
        return builder.build();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.graphql.websocket", name={"path"})
    public static class WebSocketConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public GraphQlWebSocketHandler graphQlWebSocketHandler(WebGraphQlHandler webGraphQlHandler, GraphQlProperties properties, ServerCodecConfigurer configurer) {
            return new GraphQlWebSocketHandler(webGraphQlHandler, configurer, properties.getWebsocket().getConnectionInitTimeout());
        }

        @Bean
        public HandlerMapping graphQlWebSocketEndpoint(GraphQlWebSocketHandler graphQlWebSocketHandler, GraphQlProperties properties) {
            String path = properties.getWebsocket().getPath();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("GraphQL endpoint WebSocket " + path));
            }
            SimpleUrlHandlerMapping mapping = new SimpleUrlHandlerMapping();
            mapping.setHandlerPredicate((BiPredicate)new WebSocketUpgradeHandlerPredicate());
            mapping.setUrlMap(Collections.singletonMap(path, graphQlWebSocketHandler));
            mapping.setOrder(-2);
            return mapping;
        }
    }

    @Configuration(proxyBeanMethods=false)
    public static class GraphQlEndpointCorsConfiguration
    implements WebFluxConfigurer {
        final GraphQlProperties graphQlProperties;
        final GraphQlCorsProperties corsProperties;

        public GraphQlEndpointCorsConfiguration(GraphQlProperties graphQlProps, GraphQlCorsProperties corsProps) {
            this.graphQlProperties = graphQlProps;
            this.corsProperties = corsProps;
        }

        public void addCorsMappings(CorsRegistry registry) {
            CorsConfiguration configuration = this.corsProperties.toCorsConfiguration();
            if (configuration != null) {
                registry.addMapping(this.graphQlProperties.getPath()).combine(configuration);
            }
        }
    }
}

