/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.graphql.data;

import graphql.GraphQL;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.graphql.GraphQlAutoConfiguration;
import org.springframework.boot.autoconfigure.graphql.GraphQlSourceBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.ReactiveQuerydslPredicateExecutor;
import org.springframework.graphql.data.query.QuerydslDataFetcher;
import org.springframework.graphql.execution.GraphQlSource;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={GraphQL.class, QuerydslDataFetcher.class, QuerydslPredicateExecutor.class})
@ConditionalOnBean(value={GraphQlSource.class})
@AutoConfigureAfter(value={GraphQlAutoConfiguration.class})
public class GraphQlQuerydslAutoConfiguration {
    @Bean
    public GraphQlSourceBuilderCustomizer querydslRegistrar(ObjectProvider<QuerydslPredicateExecutor<?>> executorsProvider, ObjectProvider<ReactiveQuerydslPredicateExecutor<?>> reactiveExecutorsProvider) {
        return builder -> {
            List executors = executorsProvider.stream().collect(Collectors.toList());
            if (!executors.isEmpty()) {
                List reactiveExecutors = reactiveExecutorsProvider.stream().collect(Collectors.toList());
                builder.configureRuntimeWiring(QuerydslDataFetcher.autoRegistrationConfigurer(executors, reactiveExecutors));
            }
        };
    }
}

